/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.HDDInfo.parsers;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.HDDInfo.HwInfoCollection;
import Gbt.utility.HDDInfo.data.MemHwInfo;
import Gbt.utility.HDDInfo.parsers.HwInfoParser;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public final class ParserMEMInfo
extends HwInfoParser {
    public ParserMEMInfo(File binFile) {
        super(binFile, HwInfoCollection.MEM_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AbstractJSONPOJO> parseHwInfo() {
        ArrayList<AbstractJSONPOJO> dataList = new ArrayList<AbstractJSONPOJO>();
        if (this.offset == -1) {
            return dataList;
        }
        MemHwInfo memHwInfo = new MemHwInfo();
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(this.binFile));
            ((DataInputStream)dis).skipBytes(this.offset);
            byte[] signature = new byte[8];
            ((DataInputStream)dis).read(signature, 0, signature.length);
            byte[] maxSizebytes = new byte[4];
            ((DataInputStream)dis).read(maxSizebytes, 0, maxSizebytes.length);
            memHwInfo.setMaxSize(new BigDecimal(GbtCommonConverters.ByteArraytoInt(maxSizebytes)));
            byte[] numberOfSlotbytes = new byte[4];
            ((DataInputStream)dis).read(numberOfSlotbytes, 0, numberOfSlotbytes.length);
            memHwInfo.setNumberOfSlot(new BigDecimal(GbtCommonConverters.ByteArraytoInt(numberOfSlotbytes)));
            dataList.add(memHwInfo);
            ArrayList<AbstractJSONPOJO> arrayList = dataList;
            return arrayList;
        }
        catch (IOException ioe) {
            ArrayList<AbstractJSONPOJO> arrayList = dataList;
            return arrayList;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    dis = null;
                }
            }
        }
    }
}

