/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.RAW;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.utility.RAW.IPMIRawCommand;

public enum CommonIPMIOptions implements GbtIPMIOptions<IPMIRawCommand.Builder>
{
    RawCommand(0, "raw", 0, 0),
    Get3LANMAC(1, "get3mac", 56, 48);

    private static final int RAW_COMMAND_CODE = 0;
    private static final String RAW_COMMAND_ITEM = "raw";
    private static final int GET3MAC_COMMAND_CODE = 1;
    private static final String GET3MAC_COMMAND_ITEM = "get3mac";
    private final int optionCode;
    private final String item;
    private final byte netFn;
    private final byte cmd;

    private CommonIPMIOptions(int optionCode, String item, byte netFn, byte cmd) {
        this.optionCode = optionCode;
        this.netFn = netFn;
        this.item = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return this.netFn;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(IPMIRawCommand.Builder commandArgs) {
        switch (this.optionCode) {
            case 0: {
                if (commandArgs.rawData.length < 3) {
                    return null;
                }
                byte[] rawRequest = new byte[commandArgs.rawData.length - 2];
                System.arraycopy(commandArgs.rawData, 2, rawRequest, 0, rawRequest.length);
                return rawRequest;
            }
            case 1: {
                return new byte[]{2};
            }
        }
        return null;
    }

    @Override
    public GbtIpmiCommandResponseData parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        return gbtResponseData;
    }
}

