/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SEL;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SDR.record.ReadingType;
import Gbt.utility.SDR.record.SensorType;
import Gbt.utility.SEL.EventMegRev;
import Gbt.utility.SEL.GeneratorIDAddressType;
import Gbt.utility.SEL.SELCommand;
import Gbt.utility.SEL.SELEntryJSONData;
import Gbt.utility.SEL.SELInfoJSONData;
import com.veraxsystems.vxipmi.coding.commands.sel.EventDirection;
import com.veraxsystems.vxipmi.coding.commands.sel.SelRecordType;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;

public enum SELIPMIOptions implements GbtIPMIOptions<SELCommand.Builder>
{
    Unknown(0, "unknown", 64),
    Info(0, "info", 64),
    List(1, "list", 67),
    Clear(2, "clear", 71),
    TimeGet(3, "timeget", 72),
    TimeSet(4, "timeset", 73);

    private static final int INFO_CODE = 0;
    private static final int LIST_CODE = 1;
    private static final int CLEAR_CODE = 2;
    private static final int TIMEGET_CODE = 3;
    private static final int TIMESET_CODE = 4;
    private static final String UNKNOWN_ITEM = "unknown";
    private static final String INFO_ITEM = "info";
    private static final String LIST_ITEM = "list";
    private static final String CLEAR_ITEM = "clear";
    private static final String TIMEGET_ITEM = "timeget";
    private static final String TIMESET_ITEM = "timeset";
    private final int optionCode;
    private final String optionItem;
    private static final byte NET_FN = 10;
    private final byte cmd;

    private SELIPMIOptions(int code, String item, byte cmd) {
        this.optionCode = code;
        this.optionItem = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.optionItem;
    }

    @Override
    public byte getNetFn() {
        return 10;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(SELCommand.Builder commandArgs) {
        switch (this) {
            case Info: {
                return null;
            }
            case List: {
                byte[] buffer = TypeConverter.intToByteArray(commandArgs.recordID);
                return new byte[]{commandArgs.reserveID[0], commandArgs.reserveID[1], buffer[3], buffer[2], 0, -1};
            }
            case Clear: {
                return new byte[]{commandArgs.reserveID[0], commandArgs.reserveID[1], 67, 76, 82, -86};
            }
            case TimeGet: {
                return null;
            }
            case TimeSet: {
                return GbtCommonConverters.javaDateToIPMIBytes(commandArgs.selDate);
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        byte[] buffer = new byte[4];
        byte[] raw = gbtResponseData.getAllResponseData();
        switch (this) {
            case Info: {
                SELInfoJSONData data = new SELInfoJSONData();
                int majorVer = raw[0] & 0xF;
                int minorVer = (raw[0] & 0xFFFFFFF0) >> 4;
                data.setSELVersion(majorVer + "." + minorVer);
                int entriesCount = (TypeConverter.byteToInt(raw[2]) << 8) + TypeConverter.byteToInt(raw[1]);
                data.setEntriesCount(new BigDecimal(entriesCount));
                int freeSpace = (TypeConverter.byteToInt(raw[4]) << 8) + TypeConverter.byteToInt(raw[3]);
                data.setFreeSpace(new BigDecimal(freeSpace));
                System.arraycopy(raw, 5, buffer, 0, 4);
                if (this.isDateAvailable(buffer)) {
                    data.setAdditionTimestamp(GbtCommonConverters.ipmiBytesToJavaDate(buffer).toString());
                } else {
                    data.setAdditionTimestamp("Not Available");
                }
                System.arraycopy(raw, 9, buffer, 0, 4);
                if (this.isDateAvailable(buffer)) {
                    data.setEraseTimestamp(GbtCommonConverters.ipmiBytesToJavaDate(buffer).toString());
                } else {
                    data.setEraseTimestamp("Not Available");
                }
                data.setOverflow((TypeConverter.byteToInt(raw[13]) & 0x80) != 0);
                data.setDeleteSELSupport((TypeConverter.byteToInt(raw[13]) & 8) != 0);
                data.setPartialAddSELSupport((TypeConverter.byteToInt(raw[13]) & 4) != 0);
                data.setReserveSupported((TypeConverter.byteToInt(raw[13]) & 2) != 0);
                data.setAllocInfoSupported((TypeConverter.byteToInt(raw[13]) & 1) != 0);
                return data;
            }
            case List: {
                if (gbtResponseData.getCompletionCode() == CompletionCode.DataNotPresent) {
                    return new NullJSONData().setError(false).setMessages("SEL has no entries.");
                }
                SELEntryJSONData record = new SELEntryJSONData();
                record.setRaw_data(raw);
                System.arraycopy(raw, 0, buffer, 0, 2);
                record.setNextRecordId(BigInteger.valueOf(TypeConverter.littleEndianByteArrayToInt(buffer)));
                System.arraycopy(raw, 2, buffer, 0, 2);
                record.setRecordId(BigInteger.valueOf(TypeConverter.littleEndianByteArrayToInt(buffer)));
                record.setRecordType(SelRecordType.parseInt(TypeConverter.byteToInt(raw[4])));
                System.arraycopy(raw, 5, buffer, 0, 4);
                record.setTimestamp(TypeConverter.decodeDate(TypeConverter.littleEndianByteArrayToInt(buffer)));
                record.setGeneratorID(raw[9]);
                byte i2cAddr = (byte)((raw[9] & 0xFFFFFFFE) >> 1);
                record.setI2cAddress(i2cAddr);
                record.setI2cIdType(GeneratorIDAddressType.parseByByte(raw[9]));
                byte channelNum = (byte)((raw[10] & 0xFFFFFFF0) >> 4);
                record.setI2cChannelNumber(channelNum);
                record.setEventMessagesRevision(EventMegRev.parseByByte(raw[11]));
                record.setSensorType(SensorType.parseInt(TypeConverter.byteToInt(raw[12])));
                record.setSensorNumber(raw[13]);
                record.setEventDirection(EventDirection.parseInt((TypeConverter.byteToInt(raw[14]) & 0x80) >> 7));
                int eventType = TypeConverter.byteToInt(raw[14]) & 0x7F;
                int eventOffset = TypeConverter.byteToInt(raw[15]) & 0xF;
                record.setEventType(ReadingType.parseInt(record.getSensorType(), eventType, eventOffset));
                record.setTriggeredReading(raw[16]);
                byte[] addbuffer = new byte[]{raw[15], raw[16], raw[17]};
                record.setAdditionalDescription(addbuffer);
                return record;
            }
            case Clear: {
                return new NullJSONData().setError(false).setMessages((raw[0] & 1) == 1 ? "complete" : "progress");
            }
            case TimeGet: {
                SELInfoJSONData selTime = new SELInfoJSONData();
                selTime.setSELCurrentTime(GbtCommonConverters.ipmiBytesToJavaDate(raw).toString());
                return selTime;
            }
            case TimeSet: {
                return new NullJSONData().setError(false).setMessages("SEL " + this.getItem() + " command success.");
            }
        }
        return new NullJSONData().setError(true).setMessages("Unsupport SEL command option.");
    }

    private boolean isDateAvailable(byte[] date) {
        int count = 0;
        for (byte aDate : date) {
            if (aDate != -1 && aDate != 0) continue;
            ++count;
        }
        return count != 4;
    }

    public static final SELIPMIOptions parse(String rawString) {
        if (rawString == null) {
            return Unknown;
        }
        switch (rawString.toLowerCase()) {
            case "info": {
                return Info;
            }
            case "list": {
                return List;
            }
            case "clear": {
                return Clear;
            }
            case "timeget": {
                return TimeGet;
            }
            case "timeset": {
                return TimeSet;
            }
        }
        return Unknown;
    }
}

