/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SEL;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.text.DecimalFormat;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public final class SELInfoJSONData
extends AbstractJSONPOJO {
    private String bmcIP;
    private String selVersion;
    private BigDecimal entriesCount;
    private BigDecimal freeSpace;
    private String useage;
    private String additionTimestamp;
    private String eraseTimestamp;
    private Boolean selOverflow;
    private Boolean deleteSELSupport;
    private Boolean partialAddSELSupport;
    private Boolean reserveSupported;
    private Boolean allocInfoSupported;
    private String selCurrentTime;

    public void setBMCIP(String bmcIP) {
        this.bmcIP = bmcIP;
    }

    @JsonProperty(value="BMC IP")
    public String getBMCIP() {
        return this.bmcIP;
    }

    public void setSELVersion(String selVersion) {
        this.selVersion = selVersion;
    }

    @JsonProperty(value="Version")
    public String getSELVersion() {
        return this.selVersion;
    }

    public void setEntriesCount(BigDecimal entriesCount) {
        this.entriesCount = entriesCount;
    }

    @JsonProperty(value="Entries")
    public BigDecimal getEntriesCount() {
        return this.entriesCount;
    }

    public void setFreeSpace(BigDecimal freeSpace) {
        this.freeSpace = freeSpace;
    }

    @JsonProperty(value="Free Space (bytes)")
    public BigDecimal getFreeSpace() {
        return this.freeSpace;
    }

    public void setUseage(String useage) {
        this.useage = useage;
    }

    @JsonProperty(value="Percent Used")
    public String getPercentsUsage() {
        if (this.entriesCount == null || this.freeSpace == null) {
            return this.useage;
        }
        float usage = Float.intBitsToFloat(this.entriesCount.intValue() * 1600);
        float total = Float.intBitsToFloat(this.freeSpace.intValue() + this.entriesCount.intValue() * 16);
        this.useage = new DecimalFormat("0.0").format(usage / total) + "%";
        return this.useage;
    }

    public void setAdditionTimestamp(String additionTimestamp) {
        this.additionTimestamp = additionTimestamp;
    }

    @JsonProperty(value="Last Add Time")
    public String getAdditionTimestamp() {
        return this.additionTimestamp;
    }

    public void setEraseTimestamp(String eraseTimestamp) {
        this.eraseTimestamp = eraseTimestamp;
    }

    @JsonProperty(value="Last Del Time")
    public String getEraseTimestamp() {
        return this.eraseTimestamp;
    }

    public void setOverflow(boolean overflow) {
        this.selOverflow = overflow;
    }

    @JsonProperty(value="Overflow")
    public Boolean isOverflow() {
        return this.selOverflow;
    }

    public void setDeleteSELSupport(Boolean deleteSELSupport) {
        this.deleteSELSupport = deleteSELSupport;
    }

    @JsonProperty(value="Delete SEL Support")
    public Boolean isDeleteSELSupport() {
        return this.deleteSELSupport;
    }

    public void setPartialAddSELSupport(Boolean partialAddSELSupport) {
        this.partialAddSELSupport = partialAddSELSupport;
    }

    @JsonProperty(value="Partial Add SEL Support")
    public Boolean isPartialAddSELSupport() {
        return this.partialAddSELSupport;
    }

    public void setReserveSupported(Boolean reserveSupported) {
        this.reserveSupported = reserveSupported;
    }

    @JsonProperty(value="Reserve Supported")
    public Boolean isReserveSupported() {
        return this.reserveSupported;
    }

    public void setAllocInfoSupported(Boolean allocInfoSupported) {
        this.allocInfoSupported = allocInfoSupported;
    }

    @JsonProperty(value="Alloc Info Supported")
    public Boolean isAllocInfoSupported() {
        return this.allocInfoSupported;
    }

    public void setSELCurrentTime(String time) {
        this.selCurrentTime = time;
    }

    @JsonProperty(value="SEL current time")
    public String getSELCurrentTime() {
        return this.selCurrentTime;
    }
}

