/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMTP;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.API.GbtUtilityAPI2;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SMTP.SMTPEmailJSONData;
import Gbt.utility.SMTP.SMTPIPMIOptions;
import Gbt.utility.SMTP.SMTPJSONData;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class SMTPCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "smtp";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected SMTPCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Check arguments fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI ipmiReceiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        CommandTaskRecords report = GbtUtilityAPI2.commonCommand(GbtCommandBuilders.mcinfo(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword));
        AbstractJSONPOJO data = report.getResultData().get(0);
        if (data instanceof NullJSONData) {
            NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        BMCInfoJSONData bmcInfo = data.castConcreteJSON(BMCInfoJSONData.class);
        switch (bmcInfo.getBmcVendor()) {
            case VERTIV: {
                break;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + (Object)((Object)bmcInfo.getBmcVendor()) + " FW.");
                return false;
            }
        }
        if (!bmcInfo.isAST2500()) {
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support " + (Object)((Object)bmcInfo.getBmcGen()) + ".");
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute SMTP command.");
        SMTPJSONData smtpData = new SMTPJSONData();
        switch (((Builder)this.commandArgs).smtpOptions) {
            case SetSenderInfo: {
                if (this.sendIPMISetSMTPSeries(handle)) break;
                return false;
            }
            case SetEmail: {
                if (this.sendIPMISetSMTPSeries(handle)) break;
                return false;
            }
            case SetServerAddr: {
                if (this.sendIPMISetSMTPSeries(handle)) break;
                return false;
            }
            case SetAuthority: {
                if (this.sendIPMISetSMTPSeries(handle)) break;
                return false;
            }
            case GetSenderInfo: {
                smtpData = this.sendIPMIGetSenderInfo(handle);
                if (smtpData == null) {
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, smtpData.toString());
                break;
            }
            case GetEmail: {
                List<SMTPEmailJSONData> list = this.sendIPMIGetSMTPEmails(handle);
                if (list == null) {
                    return false;
                }
                smtpData.setEmails(list);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, smtpData.toString());
                break;
            }
            case GetServerAddr: {
                smtpData = this.sendIPMIGetServer(handle);
                if (smtpData == null) {
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, smtpData.toString());
                break;
            }
            case GetAuthority: {
                smtpData = this.sendIPMIGetAuthority(handle);
                if (smtpData == null) {
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, smtpData.toString());
                break;
            }
            default: {
                smtpData.setSenderInfo(this.sendIPMIGetSenderInfo(handle).getSenderInfo());
                smtpData.setEmails(this.sendIPMIGetSMTPEmails(handle));
                SMTPJSONData cache = this.sendIPMIGetServer(handle);
                smtpData.setServerPort(cache.getServerPort());
                smtpData.setServerIP(cache.getServerIP());
                cache = this.sendIPMIGetAuthority(handle);
                smtpData.setServerEnable(cache.isServerEnable());
                smtpData.setServerUsername(cache.getServerUsername());
                smtpData.setServerPassword(cache.getServerPassword());
                smtpData.setTLSMode(cache.getTLSMode());
                smtpData.setSASLMode(cache.getSASLMode());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, smtpData.toString());
            }
        }
        this.commandResults.add(smtpData);
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    private boolean sendIPMISetSMTPSeries(ConnectionHandle handle) {
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, ((Builder)this.commandArgs).smtpOptions, this.commandArgs, COMMAND_NAME, this.commandID);
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            if (temp.isError()) {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
        }
        return true;
    }

    private SMTPJSONData sendIPMIGetSenderInfo(ConnectionHandle handle) {
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, SMTPIPMIOptions.GetSenderInfo, this.commandArgs, COMMAND_NAME, this.commandID);
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            if (temp.isError()) {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return null;
            }
        }
        return resp.castConcreteJSON(SMTPJSONData.class);
    }

    private List<SMTPEmailJSONData> sendIPMIGetSMTPEmails(ConnectionHandle handle) {
        ArrayList<SMTPEmailJSONData> list = new ArrayList<SMTPEmailJSONData>();
        for (int i = 1; i <= 4; ++i) {
            AbstractJSONPOJO temp;
            ((Builder)this.commandArgs).getEmailAddresses();
            ((Builder)this.commandArgs).emailID = (byte)(i + 6);
            AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, SMTPIPMIOptions.GetEmail, this.commandArgs, COMMAND_NAME, this.commandID);
            if (resp instanceof NullJSONData) {
                temp = resp.castConcreteJSON(NullJSONData.class);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + ((NullJSONData)temp).getMessages());
                if (!((NullJSONData)temp).isError()) continue;
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return null;
            }
            if (!(resp instanceof SMTPEmailJSONData)) continue;
            temp = resp.castConcreteJSON(SMTPEmailJSONData.class);
            ((SMTPEmailJSONData)temp).setEmailId(new BigDecimal(i));
            list.add((SMTPEmailJSONData)temp);
        }
        return list;
    }

    private SMTPJSONData sendIPMIGetServer(ConnectionHandle handle) {
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, SMTPIPMIOptions.GetServerAddr, this.commandArgs, COMMAND_NAME, this.commandID);
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            if (temp.isError()) {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return null;
            }
        }
        return resp.castConcreteJSON(SMTPJSONData.class);
    }

    private SMTPJSONData sendIPMIGetAuthority(ConnectionHandle handle) {
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, SMTPIPMIOptions.GetAuthority, this.commandArgs, COMMAND_NAME, this.commandID);
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            if (temp.isError()) {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return null;
            }
        }
        return resp.castConcreteJSON(SMTPJSONData.class);
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private SMTPIPMIOptions smtpOptions;
        protected byte[] senderInfo;
        protected byte enable;
        protected byte emailID = (byte)7;
        protected byte[] emailAddr;
        protected byte[] emailDescription;
        protected byte[] portBytes;
        protected byte[] serverAddr;
        protected byte[] usernameBytes;
        protected byte[] passwordBytes;
        protected byte TLSMode;
        protected byte SASLMode;

        public Builder() {
            this.smtpOptions = SMTPIPMIOptions.FullGetSMTP;
        }

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, "0.0.0.0_smtp", "BMC IP address is null.");
                return false;
            }
            if (this.args != null) {
                if (this.args.length < 2) {
                    this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invaliad arguments length.");
                    return false;
                }
                switch (this.args[0]) {
                    case "set": {
                        return this.checkLineArgs(this.args[1]);
                    }
                    case "get": {
                        if (this.args.length != 2) {
                            return false;
                        }
                        switch (this.args[1]) {
                            case "info": {
                                this.getSenderInfo();
                                return true;
                            }
                            case "email": {
                                this.getEmailAddresses();
                                return true;
                            }
                            case "server": {
                                this.getServerAddress();
                                return true;
                            }
                            case "auth": {
                                this.getServerAuthority();
                                return true;
                            }
                        }
                        return false;
                    }
                }
                this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invaliad arguments of smtp command.");
                return false;
            }
            switch (this.smtpOptions) {
                case SetSenderInfo: {
                    if (this.senderInfo.length <= 128) break;
                    this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Given SMTP sender info strings are out of 128 chars.");
                    return false;
                }
                case SetEmail: {
                    if (this.emailID < 7 || this.emailID > 10) {
                        this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Given SMTP email ID number out of range (1~4).");
                        return false;
                    }
                    if (this.emailAddr.length > 64) {
                        this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Given SMTP email address are out of 64 chars.");
                        return false;
                    }
                    if (this.emailDescription.length <= 64) break;
                    this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Given SMTP email description are out of 64 chars.");
                    return false;
                }
                case SetAuthority: {
                    if (this.usernameBytes.length > 64) {
                        this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Given SMTP username are out of 64 chars.");
                        return false;
                    }
                    if (this.passwordBytes.length > 64) {
                        this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Given SMTP password are out of 64 chars.");
                        return false;
                    }
                    if (this.TLSMode > 2) {
                        this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Unrecognized SMTP TLS mode.");
                        return false;
                    }
                    if (this.SASLMode <= 4) break;
                    this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Unrecognized SMTP SASL mode.");
                    return false;
                }
                case GetSenderInfo: {
                    this.getSenderInfo();
                    break;
                }
                case GetEmail: {
                    if (this.emailID < 7 || this.emailID > 10) {
                        this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Given SMTP email ID number out of range (1~4).");
                        return false;
                    }
                    this.getEmailAddresses();
                    break;
                }
                case GetServerAddr: {
                    this.getServerAddress();
                    break;
                }
                case GetAuthority: {
                    this.getServerAuthority();
                    break;
                }
                case FullGetSMTP: {
                    this.getFullConfig();
                    break;
                }
                default: {
                    this.loggerWriter.appendPath(SMTPCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + SMTPCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invaliad arguments of smtp command.");
                    return false;
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SMTPCommand build() {
            return new SMTPCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.senderInfo = null;
            this.enable = 0;
            this.emailID = 0;
            this.emailAddr = null;
            this.emailDescription = null;
            this.portBytes = null;
            this.serverAddr = null;
            this.usernameBytes = null;
            this.passwordBytes = null;
            this.TLSMode = 0;
            this.SASLMode = 0;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setSenderInfo(String messages) {
            this.senderInfo = messages.getBytes(StandardCharsets.US_ASCII);
            this.smtpOptions = SMTPIPMIOptions.SetSenderInfo;
            return this.getThis();
        }

        public Builder getSenderInfo() {
            this.smtpOptions = SMTPIPMIOptions.GetSenderInfo;
            return this.getThis();
        }

        public Builder setEmailAddress(int emailID, boolean enable, String emailAddr, String description, boolean isIpv4) {
            byte[] tmp;
            this.emailID = (byte)(emailID + 6);
            this.emailAddr = emailAddr.getBytes(StandardCharsets.US_ASCII);
            if (this.emailAddr.length < 64) {
                tmp = new byte[64];
                System.arraycopy(this.emailAddr, 0, tmp, 0, this.emailAddr.length);
                this.emailAddr = tmp;
            }
            this.enable = isIpv4 ? (enable ? (byte)1 : 0) : (enable ? (byte)2 : (byte)0);
            this.emailDescription = description.getBytes(StandardCharsets.US_ASCII);
            if (this.emailDescription.length < 64) {
                tmp = new byte[64];
                System.arraycopy(this.emailDescription, 0, tmp, 0, this.emailDescription.length);
                this.emailDescription = tmp;
            }
            this.smtpOptions = SMTPIPMIOptions.SetEmail;
            return this.getThis();
        }

        public Builder getEmailAddresses() {
            this.smtpOptions = SMTPIPMIOptions.GetEmail;
            return this.getThis();
        }

        public Builder setServerAddress(int port, String serverAddr) {
            this.portBytes = new byte[2];
            this.portBytes[0] = (byte)port;
            this.portBytes[1] = (byte)(port >>> 8);
            this.serverAddr = GbtCommonConverters.ipToBigInteger(serverAddr).toByteArray();
            if (this.serverAddr[0] == 0) {
                byte[] tmp = new byte[this.serverAddr.length - 1];
                System.arraycopy(this.serverAddr, 1, tmp, 0, tmp.length);
                this.serverAddr = tmp;
            }
            this.smtpOptions = SMTPIPMIOptions.SetServerAddr;
            return this.getThis();
        }

        public Builder getServerAddress() {
            this.smtpOptions = SMTPIPMIOptions.GetServerAddr;
            return this.getThis();
        }

        public Builder setServerAuthority(boolean enable, String username, String password, TLSModeOptions TLSMode, SASLModeOptions SASLMode) {
            this.enable = enable ? (byte)1 : 0;
            this.usernameBytes = this.userAndPasswordToBytes(username);
            this.passwordBytes = this.userAndPasswordToBytes(password);
            this.TLSMode = TLSMode.getOptionCode();
            this.SASLMode = SASLMode.getOptionCode();
            this.smtpOptions = SMTPIPMIOptions.SetAuthority;
            return this.getThis();
        }

        public Builder getServerAuthority() {
            this.smtpOptions = SMTPIPMIOptions.GetAuthority;
            return this.getThis();
        }

        public Builder getFullConfig() {
            this.smtpOptions = SMTPIPMIOptions.FullGetSMTP;
            return this.getThis();
        }

        private byte[] userAndPasswordToBytes(String input) {
            byte[] output;
            byte[] temp = input.getBytes(StandardCharsets.US_ASCII);
            if (temp.length < (output = new byte[64]).length) {
                for (int i = 0; i < output.length; ++i) {
                    output[i] = i < temp.length ? temp[i] : (byte)0;
                }
            } else {
                output = temp;
            }
            return output;
        }

        private boolean checkLineArgs(String keywords) {
            switch (keywords) {
                case "info": {
                    if (this.args.length != 3) {
                        return false;
                    }
                    this.setSenderInfo(this.args[2]);
                    return this.senderInfo.length <= 128;
                }
                case "email": {
                    if (this.args.length != 7) {
                        return false;
                    }
                    int IDNum = Integer.parseInt(this.args[2]);
                    if (IDNum < 1 || IDNum > 4) {
                        return false;
                    }
                    this.setEmailAddress(IDNum, this.args[3].equals("on"), this.args[4], this.args[5], this.args[6].toLowerCase().equals("ipv4"));
                    return this.emailDescription.length <= 64;
                }
                case "server": {
                    if (this.args.length != 4) {
                        return false;
                    }
                    this.setServerAddress(Integer.parseInt(this.args[2]), this.args[3]);
                    return true;
                }
                case "auth": {
                    SASLModeOptions Smode;
                    TLSModeOptions Tmode;
                    if (this.args.length != 7) {
                        return false;
                    }
                    boolean ONOFF = false;
                    if (this.args[2].equals("on")) {
                        ONOFF = true;
                    }
                    switch (this.args[5]) {
                        case "off": {
                            Tmode = TLSModeOptions.OFF;
                            break;
                        }
                        case "auto": {
                            Tmode = TLSModeOptions.AUTO;
                            break;
                        }
                        case "on": {
                            Tmode = TLSModeOptions.ON;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    switch (this.args[6]) {
                        case "auto": {
                            Smode = SASLModeOptions.AUTO;
                            break;
                        }
                        case "plain": {
                            Smode = SASLModeOptions.PLAIN;
                            break;
                        }
                        case "login": {
                            Smode = SASLModeOptions.LOGIN;
                            break;
                        }
                        case "htlm": {
                            Smode = SASLModeOptions.HTLM;
                            break;
                        }
                        case "md5": {
                            Smode = SASLModeOptions.MD5;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    this.setServerAuthority(ONOFF, this.args[3], this.args[4], Tmode, Smode);
                    if (this.usernameBytes.length > 64) {
                        return false;
                    }
                    return this.passwordBytes.length <= 64;
                }
            }
            return false;
        }

        public static enum SASLModeOptions {
            AUTO(0),
            PLAIN(1),
            LOGIN(2),
            HTLM(3),
            MD5(4);

            private final byte optionCode;

            private SASLModeOptions(byte optionCode) {
                this.optionCode = optionCode;
            }

            public byte getOptionCode() {
                return this.optionCode;
            }
        }

        public static enum TLSModeOptions {
            OFF(0),
            AUTO(1),
            ON(2);

            private final byte optionCode;

            private TLSModeOptions(byte optionCode) {
                this.optionCode = optionCode;
            }

            public byte getOptionCode() {
                return this.optionCode;
            }
        }
    }
}

