/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update;

import com.fasterxml.jackson.annotation.JsonValue;

public enum UpdateType {
    UNKNOWN(0, "Unknown"),
    BMC(0, "BMC"),
    BIOS(2, "BIOS"),
    CPLDBPB(4, "BPB_CPLD"),
    CPLDMB(5, "MB_CPLD"),
    PSU(6, "PSU"),
    SKU(3, "SKU"),
    CMC(0, "CMC");

    private static final byte UPDATE_BMC_CODE = 0;
    private static final byte UPDATE_BIOS_CODE = 2;
    private static final byte UPDATE_CPLD_BPB_CODE = 4;
    private static final byte UPDATE_CPLD_MB_CODE = 5;
    private static final byte UPDATE_PSU_CODE = 6;
    private static final byte UPDATE_SKU_CODE = 3;
    private static final byte UPDATE_CMC_CODE = 0;
    private static final String UNKNOWN_ITEM = "Unknown";
    private static final String UPDATE_BMC_ITEM = "BMC";
    private static final String UPDATE_BIOS_ITEM = "BIOS";
    private static final String UPDATE_CPLD_BPB_ITEM = "BPB_CPLD";
    private static final String UPDATE_CPLD_MB_ITEM = "MB_CPLD";
    private static final String UPDATE_PSU_ITEM = "PSU";
    private static final String UPDATE_SKU_ITEM = "SKU";
    private static final String UPDATE_CMC_ITEM = "CMC";
    private final byte code;
    private final String item;

    private UpdateType(byte code, String item) {
        this.code = code;
        this.item = item;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public byte getTypeCode() {
        return this.code;
    }

    public boolean isBMC() {
        return this == BMC;
    }

    public boolean isBIOS() {
        return this == BIOS;
    }

    public boolean isCPLD() {
        return this == CPLDBPB || this == CPLDMB;
    }

    public boolean isPSU() {
        return this == PSU;
    }

    public boolean isSKU() {
        return this == SKU;
    }

    public boolean isCMC() {
        return this == CMC;
    }

    public static final UpdateType parse(String typeName) {
        switch (typeName.toUpperCase()) {
            case "BMC": {
                return BMC;
            }
            case "BIOS": {
                return BIOS;
            }
            case "BPB_CPLD": {
                return CPLDBPB;
            }
            case "MB_CPLD": {
                return CPLDMB;
            }
            case "PSU": {
                return PSU;
            }
            case "SKU": {
                return SKU;
            }
            case "CMC": {
                return CMC;
            }
        }
        return UNKNOWN;
    }

    public static final UpdateType parse(String typeName, String subTypeName) {
        switch (typeName.toUpperCase()) {
            case "BMC": {
                return BMC;
            }
            case "BIOS": {
                return BIOS;
            }
            case "BPB_CPLD": {
                return CPLDBPB;
            }
            case "MB_CPLD": {
                return CPLDMB;
            }
            case "CPLD": {
                if (subTypeName == null) {
                    return UNKNOWN;
                }
                switch (subTypeName.toUpperCase()) {
                    case "BPB": {
                        return CPLDBPB;
                    }
                    case "MB": {
                        return CPLDMB;
                    }
                }
                return UNKNOWN;
            }
            case "PSU": {
                return PSU;
            }
            case "SKU": {
                return SKU;
            }
            case "CMC": {
                return CMC;
            }
        }
        return UNKNOWN;
    }
}

