/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmcinfo;

import Gbt.utility.bmcinfo.BMCChipID;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BMCPlatform {
    Unknown("Unknown", BMCChipID.Unknown),
    Grantley("Grantley", BMCChipID.AST2400),
    Purley("Purley", BMCChipID.AST2500),
    AMD_NAPLES("AMD Naples", BMCChipID.AST2500),
    AMD_ROME("AMD ROME", BMCChipID.AST2500),
    CaviumThunderX1("Cavium ThunderX I", BMCChipID.AST2400),
    CaviumThunderX2("Cavium ThunderX II", BMCChipID.AST2500),
    MB10("MB10", BMCChipID.AST2400),
    APM("APM", BMCChipID.AST2400),
    Specific("Specific", BMCChipID.Unknown),
    G450CMC("G450CMC", BMCChipID.Unknown),
    GreenPickCMC("GreenPickCMC", BMCChipID.Unknown),
    CMC("CMC", BMCChipID.Unknown),
    BasinFalls("Basin Falls", BMCChipID.AST2500),
    Qualcomm("Qualcomm", BMCChipID.AST2500),
    PowerShelfRMC("Power Shelf RMC", BMCChipID.AST2520),
    NVMEof("NVMEof", BMCChipID.AST2520),
    Mehlow("Mehlow", BMCChipID.AST2500);

    private static final String UNKNOWN_ITEM = "Unknown";
    private static final String GRANTLEY_ITEM = "Grantley";
    private static final String PURLEY_ITEM = "Purley";
    private static final String AMD_NAPLES_ITEM = "AMD Naples";
    private static final String AMD_ROME_ITEM = "AMD ROME";
    private static final String CAVIUM_ITEM_X1 = "Cavium ThunderX I";
    private static final String CAVIUM_ITEM_X2 = "Cavium ThunderX II";
    private static final String MB10_ITEM = "MB10";
    private static final String APM_ITEM = "APM";
    private static final String SPECIFIC_ITEM = "Specific";
    private static final String CMC_ITEM = "CMC";
    private static final String G450CMC_ITEM = "G450CMC";
    private static final String GREENPICKCMC_ITEM = "GreenPickCMC";
    private static final String BASINFALLS_ITEM = "Basin Falls";
    private static final String QUALCOMM_ITEM = "Qualcomm";
    private static final String POWER_SHELF_RMC_ITEM = "Power Shelf RMC";
    private static final String NVMEOF_ITEM = "NVMEof";
    private static final String MEHLOW_ITEM = "Mehlow";
    private final String rawPlatformName;
    private final BMCChipID bmcGen;

    private BMCPlatform(String rawPlatformName, BMCChipID bmcGen) {
        this.rawPlatformName = rawPlatformName;
        this.bmcGen = bmcGen;
    }

    @JsonValue
    public String toString() {
        return this.rawPlatformName;
    }

    public BMCChipID getBmcGen() {
        return this.bmcGen;
    }

    public boolean isAST2400() {
        return this.bmcGen == BMCChipID.AST2400;
    }

    public boolean isAST2500() {
        return this.bmcGen == BMCChipID.AST2500;
    }

    public boolean isAST2520() {
        return this.bmcGen == BMCChipID.AST2520;
    }

    public boolean isPurley() {
        return this.rawPlatformName.equals(PURLEY_ITEM);
    }

    public boolean isGrantley() {
        return this.rawPlatformName.equals(GRANTLEY_ITEM);
    }

    public boolean isIntel() {
        return this.rawPlatformName.equals(PURLEY_ITEM) || this.rawPlatformName.equals(GRANTLEY_ITEM);
    }

    public boolean isAMD() {
        return this.rawPlatformName.equals(AMD_NAPLES_ITEM) || this.rawPlatformName.equals(AMD_ROME_ITEM);
    }

    public boolean isAMD_NAPLES() {
        return this.rawPlatformName.equals(AMD_NAPLES_ITEM);
    }

    public boolean isAMD_ROME() {
        return this.rawPlatformName.equals(AMD_ROME_ITEM);
    }

    public boolean isCaviumThunderX1() {
        return this.rawPlatformName.equals(CAVIUM_ITEM_X1);
    }

    public boolean isCaviumThunderX2() {
        return this.rawPlatformName.equals(CAVIUM_ITEM_X2);
    }

    public boolean isMB10() {
        return this.rawPlatformName.equals(MB10_ITEM);
    }

    public boolean isAPM() {
        return this.rawPlatformName.equals(APM_ITEM);
    }

    public boolean isSpecific() {
        return this.rawPlatformName.equals(SPECIFIC_ITEM);
    }

    public boolean isG450CMC() {
        return this.rawPlatformName.equals(G450CMC_ITEM);
    }

    public boolean isGreenPickCMC() {
        return this.rawPlatformName.equals(GREENPICKCMC_ITEM);
    }

    public boolean isPowerShelfRMC() {
        return this == PowerShelfRMC;
    }

    public boolean isNVMEof() {
        return this == NVMEof;
    }

    public boolean isCMC() {
        return this.rawPlatformName.equals(CMC_ITEM) || this.isG450CMC() || this.isGreenPickCMC();
    }

    public boolean isBasinFalls() {
        return this.rawPlatformName.equals(BASINFALLS_ITEM);
    }

    public boolean isQualcomm() {
        return this.rawPlatformName.equals(QUALCOMM_ITEM);
    }

    public boolean isUnknown() {
        return this.rawPlatformName.equals(UNKNOWN_ITEM);
    }

    public static final BMCPlatform parserPlatformByID(byte[] productID) {
        if (BMCPlatform.isPurley(productID)) {
            return Purley;
        }
        if (BMCPlatform.isAMD_Naples(productID)) {
            return AMD_NAPLES;
        }
        if (BMCPlatform.isAMD_ROME(productID)) {
            return AMD_ROME;
        }
        if (BMCPlatform.isCaviumThunderX1(productID)) {
            return CaviumThunderX1;
        }
        if (BMCPlatform.isCaviumThunderX2(productID)) {
            return CaviumThunderX2;
        }
        if (BMCPlatform.isMB10(productID)) {
            return MB10;
        }
        if (BMCPlatform.isAPM(productID)) {
            return APM;
        }
        if (BMCPlatform.isG450CMC(productID)) {
            return G450CMC;
        }
        if (BMCPlatform.isGreenPickCMC(productID)) {
            return GreenPickCMC;
        }
        if (BMCPlatform.isPowerShelfRMC(productID)) {
            return PowerShelfRMC;
        }
        if (BMCPlatform.isNVMEof(productID)) {
            return NVMEof;
        }
        if (BMCPlatform.isCMC(productID)) {
            return CMC;
        }
        if (BMCPlatform.isGrantley(productID)) {
            return Grantley;
        }
        if (BMCPlatform.isBasinFalls(productID)) {
            return BasinFalls;
        }
        if (BMCPlatform.isQualcomm(productID)) {
            return Qualcomm;
        }
        if (BMCPlatform.isMehlow(productID)) {
            return Mehlow;
        }
        if (BMCPlatform.isSpecific(productID)) {
            return Specific;
        }
        return Unknown;
    }

    private static final boolean isGrantley(byte[] productID) {
        if (productID[0] == 1) {
            return true;
        }
        return productID[0] == 3 && (productID[1] == 1 || productID[1] == 2 || productID[1] == 3 || productID[1] == 4 || productID[1] == 5 || productID[1] == 6);
    }

    private static final boolean isPurley(byte[] productID) {
        byte result = (byte)(productID[1] & 0xF0);
        if (productID[0] == 7 && productID[1] == 91) {
            return true;
        }
        if (productID[0] == 7 && productID[1] == 90) {
            return true;
        }
        if (productID[0] == 1 && result == 80) {
            return true;
        }
        if (productID[0] == 1 && result == 48) {
            return true;
        }
        return productID[0] == 1 && result == 64;
    }

    private static final boolean isAMD_Naples(byte[] productID) {
        byte result = (byte)(productID[1] & 0xF0);
        return productID[0] == 16 && result == 0;
    }

    private static final boolean isAMD_ROME(byte[] productID) {
        byte result = (byte)(productID[1] & 0xF0);
        return productID[0] == 16 && result == 48;
    }

    private static final boolean isCaviumThunderX1(byte[] productID) {
        return productID[0] == 2 && (productID[1] == 5 || productID[1] == 6 || productID[1] == 7);
    }

    private static final boolean isCaviumThunderX2(byte[] productID) {
        return productID[0] == 2 && productID[1] == 9;
    }

    private static final boolean isMB10(byte[] productID) {
        return productID[0] == 4;
    }

    private static final boolean isAPM(byte[] productID) {
        return productID[0] == 2 && productID[1] == 2;
    }

    private static final boolean isSpecific(byte[] productID) {
        return productID[1] == 2 || productID[1] == 3;
    }

    private static final boolean isCMC(byte[] productID) {
        return productID[0] == -1;
    }

    private static final boolean isG450CMC(byte[] productID) {
        return productID[0] == -1 && productID[1] == 32;
    }

    private static final boolean isGreenPickCMC(byte[] productID) {
        return productID[0] == -1 && productID[1] == 35;
    }

    private static final boolean isPowerShelfRMC(byte[] productID) {
        return productID[0] == -1 && productID[1] == 5;
    }

    private static final boolean isNVMEof(byte[] productID) {
        return productID[0] == -1 && productID[1] == 6;
    }

    private static final boolean isBasinFalls(byte[] productID) {
        return productID[0] == 5 && productID[1] < 5 && productID[1] > 0;
    }

    private static final boolean isQualcomm(byte[] productID) {
        return productID[0] == 2 && productID[1] == 16;
    }

    private static final boolean isMehlow(byte[] productID) {
        return productID[0] == 3 && productID[1] == 52;
    }
}

