/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmcinfo;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.bmcinfo.BmcDeviceIpmiOptions;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class BmcResetCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "mcreset";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected BmcResetCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start " + ((Builder)this.commandArgs).bmcDeviceIpmiOptions.getItem() + " BMC.");
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, ((Builder)this.commandArgs).bmcDeviceIpmiOptions, null, this.getCommandName(), this.commandID);
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            this.commandResults.add(temp);
            if (temp.isError()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return true;
        }
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unexcepted response.");
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return false;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private BmcDeviceIpmiOptions bmcDeviceIpmiOptions = BmcDeviceIpmiOptions.UNKNOWN;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                this.loggerWriter.appendPath(BmcResetCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, "0.0.0.0_mcreset", "BMC IP address is null.");
                return false;
            }
            if (this.args != null) {
                if (this.args.length != 1) {
                    return false;
                }
                this.bmcDeviceIpmiOptions = BmcDeviceIpmiOptions.parse(this.args[0]);
            }
            switch (this.bmcDeviceIpmiOptions) {
                case UNKNOWN: 
                case GETDEVICEID: {
                    return false;
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public BmcResetCommand build() {
            return new BmcResetCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setBmcDeviceIpmiOptions(BmcDeviceIpmiOptions bmcDeviceIpmiOptions) {
            this.bmcDeviceIpmiOptions = bmcDeviceIpmiOptions;
            return this.getThis();
        }
    }
}

