/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.maclist;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.API.GbtUtilityAPI2;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.maclist.GetLANMacIPMIOption;
import Gbt.utility.maclist.LANMacData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class GetMACListCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "mac";
    private static final int MAXIMUM_GROUP = 8;
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected GetMACListCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "IPMI command receiver is null.");
            return false;
        }
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Command arguments check fail.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        CommandTaskRecords report = GbtUtilityAPI2.commonCommand(GbtCommandBuilders.mcinfo(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword));
        AbstractJSONPOJO data = report.getResultData().get(0);
        if (data instanceof NullJSONData) {
            NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        }
        BMCInfoJSONData bmcInfo = data.castConcreteJSON(BMCInfoJSONData.class);
        switch (bmcInfo.getBmcVendor()) {
            case VERTIV: 
            case AMI: {
                break;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + (Object)((Object)bmcInfo.getBmcVendor()) + " FW.");
                return false;
            }
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to get BMC info.");
        switch (bmcInfo.getBmcGen()) {
            case AST2400: {
                data = this.ipmiReceiver.sendIPMIRawCommand(handle, GetLANMacIPMIOption.AST2400Series, this.commandArgs, COMMAND_NAME, this.commandID);
                if (data instanceof NullJSONData) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + data.castConcreteJSON(NullJSONData.class).getMessages());
                    if (data.castConcreteJSON(NullJSONData.class).isError()) {
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                }
                this.commandResults.add(data.castConcreteJSON(LANMacData.class));
                break;
            }
            default: {
                if (this.ast2500Actions(handle)) break;
                return false;
            }
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, JacksonCommonUtil.getUtil().getPrettyPrintString(this.commandResults));
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private boolean ast2500Actions(ConnectionHandle handle) {
        if (((Builder)this.commandArgs).allgroup) {
            for (int i = 0; i < 8; ++i) {
                ((Builder)this.commandArgs).groupID = i;
                AbstractJSONPOJO data = this.ipmiReceiver.sendIPMIRawCommand(handle, GetLANMacIPMIOption.AST2500Series, this.commandArgs, COMMAND_NAME, this.commandID);
                if (data instanceof NullJSONData) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + data.castConcreteJSON(NullJSONData.class).getMessages());
                    if (data.castConcreteJSON(NullJSONData.class).isError()) {
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                }
                this.commandResults.add(data.castConcreteJSON(LANMacData.class));
            }
        } else {
            AbstractJSONPOJO data = this.ipmiReceiver.sendIPMIRawCommand(handle, GetLANMacIPMIOption.AST2500Series, this.commandArgs, COMMAND_NAME, this.commandID);
            if (data instanceof NullJSONData) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + data.castConcreteJSON(NullJSONData.class).getMessages());
                if (data.castConcreteJSON(NullJSONData.class).isError()) {
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
            }
            this.commandResults.add(data.castConcreteJSON(LANMacData.class));
        }
        return true;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        protected int groupID = 0;
        private boolean allgroup = false;

        @Override
        protected Builder getThis() {
            return this;
        }

        public GetMACListCommand build() {
            return new GetMACListCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.groupID = 0;
            this.allgroup = false;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setGroupID(int groupID) {
            this.groupID = groupID;
            return this.getThis();
        }

        public Builder retrieveAllGroups() {
            this.allgroup = true;
            return this.getThis();
        }

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length != 1) {
                    return false;
                }
                switch (this.args[0]) {
                    case "all": {
                        this.allgroup = true;
                        break;
                    }
                    default: {
                        try {
                            this.groupID = Integer.parseInt(this.args[0]);
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            return false;
                        }
                    }
                }
            }
            return true;
        }
    }
}

