/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.menu;

import Gbt.utility.Common.CommonFunction;
import Gbt.utility.scan.ScanCommand;
import Gbt.utility.scan.ScanResultsData;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class ParserArgument {
    private final String[] args;
    private final Options options;
    private final CommandLineParser parser;
    private CommandLine line;
    private String[] IPAddress;
    private String username;
    private String password;
    private String redfishUsername;
    private String redfishPassword;
    private boolean logSaveTag;

    public ParserArgument(String[] args) {
        this.args = args;
        this.options = new Options();
        this.parser = new DefaultParser();
        this.logSaveTag = false;
        this.redfishUsername = "";
        this.redfishPassword = "";
    }

    public final boolean checkArgs() {
        this.setAllOptions();
        try {
            this.line = this.parser.parse(this.options, this.args);
            if (this.line.getArgs().length == 0) {
                System.out.println("Input command name is empty.");
                return false;
            }
            return true;
        }
        catch (ParseException pe) {
            System.out.println("Invalid option value : " + pe.getMessage());
            return false;
        }
    }

    public final String getCommandName() {
        return this.line.getArgs()[0];
    }

    public final boolean parserOptions(String commandName) {
        if (this.line.hasOption("v")) {
            System.out.println("Get version option, show version messages.");
            return false;
        }
        if (this.line.hasOption("h")) {
            System.out.println("Get help option, show help messages.");
            return false;
        }
        if (this.isInvalidMode()) {
            return false;
        }
        if (commandName == null) {
            return false;
        }
        switch (commandName) {
            case "scan": {
                if (!this.isScanMode()) {
                    System.out.println("Invalid options in \"" + commandName + "\" command.");
                    return false;
                }
                this.username = this.line.getOptionValue("U", "admin");
                this.password = this.line.getOptionValue("P", "password");
                return true;
            }
            case "local": {
                if (!this.isNoOptionMode()) {
                    System.out.println("Invalid options in \"" + commandName + "\" command.");
                    return false;
                }
                return true;
            }
            case "redfish": {
                this.username = this.line.getOptionValue("U", "admin");
                this.password = this.line.getOptionValue("P", "password");
                this.redfishUsername = this.line.getOptionValue("RU", "N/A");
                this.redfishPassword = this.line.getOptionValue("RP", "N/A");
                return this.parseActions();
            }
        }
        this.username = this.line.getOptionValue("U", "admin");
        this.password = this.line.getOptionValue("P", "password");
        return this.parseActions();
    }

    public final String[] getRestArgument() {
        String[] restArgs = new String[this.line.getArgs().length - 1];
        for (int i = 0; i < restArgs.length; ++i) {
            restArgs[i] = this.line.getArgs()[i + 1];
        }
        return restArgs;
    }

    public final String[] getBMCIPaddresses() {
        return this.IPAddress;
    }

    public final String getBMCUsername() {
        return this.username;
    }

    public final String getBMCPassword() {
        return this.password;
    }

    public String getRedfishUsername() {
        return this.redfishUsername;
    }

    public String getRedfishPassword() {
        return this.redfishPassword;
    }

    public final void printOptionHelp(String usage) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(usage, this.options);
    }

    public final boolean getLogSaveTag() {
        return this.logSaveTag;
    }

    private final void setAllOptions() {
        this.options.addOption("H", "hostname", true, "Execute command by this BMC IP address.");
        this.options.addOption("S", "scan", true, "Scan IP range for detect valid BMC IP addresses\nthen execute the commands for all valid BMC IP addresses.\ne.g. -S rmcp,10.1.27.1,10.1.27.15\ne.g. -S ssdp");
        this.options.addOption("L", "nodelist", true, "Set node list.");
        this.options.addOption("U", "username", true, "Set BMC user name.");
        this.options.addOption("P", "password", true, "Set BMC password.");
        this.options.addOption("RU", "redfishusername", true, "Set redfish user name.");
        this.options.addOption("RP", "redfishpassword", true, "Set redfish password.");
        this.options.addOption("h", "help", false, "Print help messages.");
        this.options.addOption("v", "version", false, "Print utility version.");
        this.options.addOption("d", "debuglog", false, "Save log with no file coverage.");
    }

    private final boolean isInvalidMode() {
        if (this.line.hasOption("H") && this.line.hasOption("S")) {
            System.out.println("Cannot execute command with both -H and -S are exist.");
            return true;
        }
        return false;
    }

    private final boolean isScanMode() {
        return !this.line.hasOption("H") && !this.line.hasOption("S");
    }

    private final boolean isNoOptionMode() {
        return !this.line.hasOption("H") && !this.line.hasOption("S") && !this.line.hasOption("U") && !this.line.hasOption("P");
    }

    private final boolean readNodelist() {
        List<String> srclist = CommonFunction.readFile(ScanCommand.getNodeList());
        if (srclist.isEmpty()) {
            System.out.println("* Node list is not exist, please use -S option first.\n");
            return false;
        }
        this.IPAddress = srclist.toArray(new String[0]);
        return true;
    }

    private final boolean readNodelist(String nodeListPath) {
        List<String> srclist = CommonFunction.readFile(nodeListPath);
        if (srclist.isEmpty()) {
            System.out.println("* Node list is not exist, please use -S option first.\n");
            return false;
        }
        this.IPAddress = srclist.toArray(new String[0]);
        return true;
    }

    private final boolean parseActions() {
        if (this.line.hasOption("d")) {
            this.logSaveTag = true;
        }
        if (this.line.hasOption("H")) {
            String hostIP = this.line.getOptionValue("H");
            if (CommonFunction.isValidateIP(hostIP)) {
                this.IPAddress = new String[]{hostIP};
                return true;
            }
            return false;
        }
        if (this.line.hasOption("S")) {
            ScanCommand command = ((ScanCommand.Builder)new ScanCommand.Builder().setCommandLineArgs(this.line.getOptionValue("S").split(","))).build();
            if (!command.checkAll()) {
                try {
                    command.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
            if (!command.execute()) {
                try {
                    command.close();
                }
                catch (Exception e) {
                    command = null;
                }
                return false;
            }
            this.IPAddress = new String[command.getCommandResults().size()];
            for (int i = 0; i < command.getCommandResults().size(); ++i) {
                this.IPAddress[i] = command.getCommandResults().get(i).castConcreteJSON(ScanResultsData.class).getBmcIpAddress();
            }
            try {
                command.close();
                return true;
            }
            catch (Exception e) {
                command = null;
                return false;
            }
        }
        if (this.line.hasOption("L")) {
            return this.readNodelist(this.line.getOptionValue("L"));
        }
        return this.readNodelist();
    }
}

