/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.power;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.API.GbtUtilityAPI2;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.power.PowerIpmiOptions;
import Gbt.utility.power.PowerLimitExceptionActions;
import Gbt.utility.power.PowerLimitInfo;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import java.math.BigDecimal;

public final class PowerLimitCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "limit";
    private final GbtIPMICommandReceiver receiver;

    protected PowerLimitCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.receiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        return this.receiver != null;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.receiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        CommandTaskRecords report = GbtUtilityAPI2.commonCommand(GbtCommandBuilders.mcinfo(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword));
        AbstractJSONPOJO data = report.getResultData().get(0);
        if (data instanceof NullJSONData) {
            NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.receiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
            return false;
        }
        BMCInfoJSONData bmcInfo = data.castConcreteJSON(BMCInfoJSONData.class);
        if (!bmcInfo.isIntel() && !bmcInfo.isAMD()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Platform not support.");
            this.receiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        AbstractJSONPOJO resp = null;
        switch (((Builder)this.commandArgs).powerIpmiOptions) {
            case GET: {
                resp = this.sendDCMICommand(handle, ((Builder)this.commandArgs).powerIpmiOptions);
                if (this.isIPMISendMessagesFail(resp)) {
                    this.receiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                if (!(resp instanceof PowerLimitInfo)) break;
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get power limit info.");
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, resp.toString());
                this.commandResults.add(resp);
                break;
            }
            case SET: {
                resp = this.receiver.sendIPMIRawCommand(handle, ((Builder)this.commandArgs).powerIpmiOptions, this.commandArgs, COMMAND_NAME, this.commandID);
                if (!this.isIPMISendMessagesFail(resp)) break;
                this.receiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case ACTIVATE: {
                resp = this.receiver.sendIPMIRawCommand(handle, ((Builder)this.commandArgs).powerIpmiOptions, this.commandArgs, COMMAND_NAME, this.commandID);
                if (!this.isIPMISendMessagesFail(resp)) break;
                this.receiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case DEACTIVATE: {
                resp = this.receiver.sendIPMIRawCommand(handle, ((Builder)this.commandArgs).powerIpmiOptions, this.commandArgs, COMMAND_NAME, this.commandID);
                if (!this.isIPMISendMessagesFail(resp)) break;
                this.receiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            default: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + ((Builder)this.commandArgs).powerIpmiOptions.getItem() + " power limit option.");
                this.receiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
        }
        this.receiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private final boolean isIPMISendMessagesFail(AbstractJSONPOJO resp) {
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            if (temp.isError()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.commandResults.add(temp);
                return true;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.commandResults.add(temp);
            return false;
        }
        return false;
    }

    private final AbstractJSONPOJO sendDCMICommand(ConnectionHandle handle, PowerIpmiOptions powerIpmiOptions) {
        AbstractJSONPOJO resp = null;
        try {
            resp = this.receiver.sendIPMIRawCommandWithIpmie(handle, powerIpmiOptions, this.commandArgs, COMMAND_NAME, this.commandID);
            this.commandResults.add(new NullJSONData().setError(false).setMessages("Send power limit " + powerIpmiOptions.getItem() + " success."));
        }
        catch (IPMIException e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + handle.getRemoteAddress().getHostAddress() + "] Completion code     : " + GbtCommonConverters.bytesToHex(GbtCommonConverters.intToByte(e.getCompletionCode().getCode())));
            resp = powerIpmiOptions == PowerIpmiOptions.GET && e.getCompletionCode().getCode() == CompletionCode.CommandSpecifedCode.getCode() ? new NullJSONData().setError(false).setMessages("No Active Set Power Limit.") : new NullJSONData().setError(true).setMessages("Send power limit " + powerIpmiOptions.getItem() + " exception.");
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + handle.getRemoteAddress().getHostAddress() + "] Send IPMI raw command fail.");
            e.printStackTrace();
            resp = e.getMessage() != null ? new NullJSONData().setError(true).setMessages(e.getMessage()) : new NullJSONData().setError(true).setMessages("Send IPMI raw command fail.");
        }
        return resp;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private PowerIpmiOptions powerIpmiOptions = PowerIpmiOptions.UNKNOWN;
        protected PowerLimitInfo powerLimitInfo = new PowerLimitInfo();

        public Builder() {
            this.powerLimitInfo.setActivate(Boolean.TRUE);
            this.powerLimitInfo.setPowerLimit(new BigDecimal(220));
            this.powerLimitInfo.setPowerLimitExceptionActions(PowerLimitExceptionActions.NOACTION);
            this.powerLimitInfo.setCorrectionTime(new BigDecimal(6000));
            this.powerLimitInfo.setSamplingPeriod(new BigDecimal(2));
        }

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length < 1) {
                    return false;
                }
                switch (this.args[0]) {
                    case "set": {
                        if (this.args.length < 2 || this.args.length > 5) {
                            return false;
                        }
                        this.setPowerOption(PowerIpmiOptions.SET);
                        try {
                            this.setPowerLimit(Integer.parseInt(this.args[1]));
                            if (this.args.length > 2) {
                                this.setPowerLimitExceptionAction(PowerLimitExceptionActions.parse(this.args[2]));
                                if (this.args.length > 3) {
                                    this.setCorrectionTime(Integer.parseInt(this.args[3]));
                                    if (this.args.length > 4) {
                                        this.setSamplingPeriod(Integer.parseInt(this.args[4]));
                                    }
                                }
                            }
                        }
                        catch (NumberFormatException ne) {
                            this.powerLimitInfo.setPowerLimit(new BigDecimal(220));
                            this.powerLimitInfo.setPowerLimitExceptionActions(PowerLimitExceptionActions.NOACTION);
                            this.powerLimitInfo.setCorrectionTime(new BigDecimal(6000));
                            this.powerLimitInfo.setSamplingPeriod(new BigDecimal(2));
                        }
                        return true;
                    }
                }
                this.powerIpmiOptions = PowerIpmiOptions.parse(this.args[0]);
            }
            return this.powerIpmiOptions != PowerIpmiOptions.UNKNOWN;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public PowerLimitCommand build() {
            return new PowerLimitCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setPowerOption(PowerIpmiOptions option) {
            this.powerIpmiOptions = option;
            return this.getThis();
        }

        public Builder setPowerLimit(int limitNum) {
            this.powerLimitInfo.setPowerLimit(new BigDecimal(limitNum));
            this.powerIpmiOptions = PowerIpmiOptions.SET;
            return this.getThis();
        }

        public Builder setPowerLimit(BigDecimal limitNum) {
            this.powerLimitInfo.setPowerLimit(limitNum);
            this.powerIpmiOptions = PowerIpmiOptions.SET;
            return this.getThis();
        }

        public Builder setPowerLimitExceptionAction(PowerLimitExceptionActions actions) {
            this.powerLimitInfo.setPowerLimitExceptionActions(actions);
            this.powerIpmiOptions = PowerIpmiOptions.SET;
            return this.getThis();
        }

        public Builder setCorrectionTime(int correctionTime) {
            this.powerLimitInfo.setCorrectionTime(new BigDecimal(correctionTime));
            this.powerIpmiOptions = PowerIpmiOptions.SET;
            return this.getThis();
        }

        public Builder setCorrectionTime(BigDecimal correctionTime) {
            this.powerLimitInfo.setCorrectionTime(correctionTime);
            this.powerIpmiOptions = PowerIpmiOptions.SET;
            return this.getThis();
        }

        public Builder setSamplingPeriod(int samplingPeriod) {
            this.powerLimitInfo.setSamplingPeriod(new BigDecimal(samplingPeriod));
            this.powerIpmiOptions = PowerIpmiOptions.SET;
            return this.getThis();
        }

        public Builder setSamplingPeriod(BigDecimal samplingPeriod) {
            this.powerLimitInfo.setSamplingPeriod(samplingPeriod);
            this.powerIpmiOptions = PowerIpmiOptions.SET;
            return this.getThis();
        }

        public Builder setPowerLimitInfo(PowerLimitInfo powerLimitInfo) {
            this.powerLimitInfo = powerLimitInfo;
            this.powerIpmiOptions = PowerIpmiOptions.SET;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.powerIpmiOptions = null;
            this.powerLimitInfo = null;
            this.loggerWriter.close();
        }
    }
}

