/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.Common.CompressFile;
import Gbt.utility.Common.UncompressFile;
import Gbt.utility.menu.GbtUtility;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.Response;

public final class BIOSSetupService
extends RESTServices {
    public static final String SERVICE_NAME = "biosmenu";
    private static final String DOWNLOAD_URL = "/api/system_inventory_gbt/bios-setup-file";
    private static final String UPLOAD_URL = "/api/system_inventory_gbt/bios-setup-file/upload";
    private final GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    private File uploadFile;

    public BIOSSetupService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "upload": {
                for (File data : dataFiles) {
                    if (!data.getName().toLowerCase().endsWith(".json")) continue;
                    this.uploadFile = data;
                    break;
                }
                return this.uploadFile.exists();
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "upload": {
                for (File data : uploadFiles) {
                    if (!data.getName().toLowerCase().endsWith(".gz")) continue;
                    this.uploadFile = data;
                    break;
                }
                return this.uploadFile.exists();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(ipAddress, this.username, this.password, "rest", logName);
        switch (restServicesOptions.getOptionName()) {
            case "upload": {
                if (!this.unlockBiosMenu(handle, logName, true)) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unlock BIOS setup menu fail.");
                    return false;
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Start upload BIOS setup menu.");
                try {
                    File gzipFile = this.uploadFile;
                    if (this.uploadFile.getName().toLowerCase().endsWith(".json")) {
                        gzipFile = CompressFile.compressGzipFile(this.uploadFile);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Compress upload temp gzip file success.");
                    }
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setCookies(this.sessionData)).setHostname(ipAddress)).setPort(this.bmcPort)).setHttpMethods(RESTHttpMethods.POST)).setServiceURI(UPLOAD_URL).setContentType("multipart/form-data")).setFormData("file", gzipFile)).build();
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.clientReceiver.deserialize(response, Object.class).toString());
                    if (this.uploadFile.getName().toLowerCase().endsWith(".json")) {
                        gzipFile.delete();
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Remove upload temp gzip file.");
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Upload BIOS setup menu success.");
                    this.jsonResults.add(new NullJSONData().setError(false).setMessages("Upload BIOS setup menu success."));
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ioe) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Compress gzip file fail.");
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Upload BIOS setup menu fail."));
                    boolean response = false;
                    return response;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Upload BIOS setup menu fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Upload BIOS setup menu fail."));
                    boolean response = false;
                    return response;
                }
                finally {
                    this.unlockBiosMenu(handle, logName, false);
                }
            }
            case "dump": {
                if (!this.unlockBiosMenu(handle, logName, true)) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unlock BIOS setup menu fail.");
                    return false;
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Start download BIOS setup menu.");
                File tempFile = new File(GbtUtility.getResultsRootPath() + "/" + "rest" + "/" + logName + ".gz");
                File dumpFile = new File(GbtUtility.getResultsRootPath() + "/" + "rest" + "/" + logName + ".json");
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setCookies(this.sessionData)).setHostname(ipAddress)).setPort(this.bmcPort)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(DOWNLOAD_URL).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.clientReceiver.downloadBase64EncodedFile(response, tempFile);
                    if (tempFile.exists()) {
                        UncompressFile.deCompressGZFile(tempFile, dumpFile);
                        tempFile.delete();
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Download success at : " + dumpFile.getAbsolutePath());
                    this.jsonResults.add(new NullJSONData().setError(false).setMessages("Download success at : " + dumpFile.getAbsolutePath()));
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Download BIOS setup menu fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Download BIOS setup menu fail."));
                    boolean bl = false;
                    return bl;
                }
                catch (IOException ioe) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Uncompress gzip file fail.");
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Download BIOS setup menu fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.unlockBiosMenu(handle, logName, false);
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }

    private boolean unlockBiosMenu(ConnectionHandle handle, String logName, boolean unlock) {
        GbtIpmiCommandResponseData respu = this.ipmiReceiver.sendRawRequest(handle, (byte)46, (byte)80, new byte[]{10, 60, 0, -124, unlock ? (byte)1 : 0}, "rest", logName);
        if (respu == null) {
            this.ipmiReceiver.closeIPMIConnection(handle, "rest", logName);
            return false;
        }
        if (respu.getCompletionCode() != CompletionCode.Ok) {
            this.ipmiReceiver.closeIPMIConnection(handle, "rest", logName);
            return false;
        }
        if (!unlock) {
            this.ipmiReceiver.closeIPMIConnection(handle, "rest", logName);
        }
        return true;
    }
}

