/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.AMIRestCAInfo;
import Gbt.utility.rest.models.AMIRestCAUpload;
import java.io.File;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class CAService
extends RESTServices {
    public static final String SERVICE_NAME = "ca";
    private static final String CA_URI = "/api/settings/ssl/certificate";
    private File caFile;
    private File keyFile;

    public CAService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "post": {
                for (File data : uploadFiles) {
                    if (!data.getName().toLowerCase().endsWith(".pem")) continue;
                    if (data.getName().toLowerCase().equals("ca.pem")) {
                        this.caFile = data;
                    }
                    if (!data.getName().toLowerCase().equals("key.pem")) continue;
                    this.keyFile = data;
                }
                return this.caFile != null && this.keyFile != null;
            }
        }
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        switch (restServicesOptions.getOptionName()) {
            case "post": {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Start upload CA file.");
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setCookies(this.sessionData)).setHostname(ipAddress)).setPort(this.bmcPort)).setHttpMethods(RESTHttpMethods.POST)).setServiceURI(CA_URI).setContentType("multipart/form-data")).setFormData("new_certificate", this.caFile)).setFormData("new_private_key", this.keyFile)).build();
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    AMIRestCAUpload caUpload = this.clientReceiver.deserialize(response, new GenericType<AMIRestCAUpload>(){});
                    this.jsonResults.add(caUpload);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, caUpload.toString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Upload CA file and key success.");
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Upload CA file and key fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Upload CA file and key fail."));
                    return false;
                }
            }
            case "get": {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Start Get CA information.");
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setCookies(this.sessionData)).setHostname(ipAddress)).setPort(this.bmcPort)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(CA_URI).setContentType("application/json")).build();
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    AMIRestCAInfo cainfo = this.clientReceiver.deserialize(response, new GenericType<AMIRestCAInfo>(){});
                    this.jsonResults.add(cainfo);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, cainfo.toString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get CA Info fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get CA Info fail."));
                    return false;
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }
}

