/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.dns.AMIRestDNSDomain;
import Gbt.utility.rest.models.dns.AMIRestDNSGeneral;
import Gbt.utility.rest.models.dns.AMIRestDNSHostname;
import Gbt.utility.rest.models.dns.AMIRestDNSRoot;
import Gbt.utility.rest.models.dns.AMIRestDNSServer;
import java.io.File;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class DnsGeneralService
extends RESTServices {
    public static final String SERVICE_NAME = "dns";
    private static final String DNS_GENERAL_URI = "/api/settings/dns/general";
    private static final String DNS_HOST_URI = "/api/settings/dns/host";
    private static final String DNS_SERVER_URI = "/api/settings/dns/server-options";
    private static final String DNS_DOMAIN_URI = "/api/settings/dns/domain-options";
    private static final String DNS_RESTART_URI = "/api/settings/dns/restart";
    private static final String DNS_URI = "/api/settings/dns";
    private AbstractJSONPOJO dnsPayload;

    public DnsGeneralService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "setdns": {
                try {
                    this.dnsPayload = (AbstractJSONPOJO)JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), restServicesOptions.getRequestPayloadType());
                }
                catch (Exception e) {
                    return false;
                }
                return this.dnsPayload != null;
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        AMIRestDNSGeneral restartPayload = new AMIRestDNSGeneral();
        switch (restServicesOptions.getOptionName()) {
            case "enable": {
                Response response;
                restartPayload.setDns_status(new BigInteger("1"));
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_GENERAL_URI).setCookies(this.sessionData)).setContentType("application/json")).setRawJsonData(restartPayload)).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.dnsPayload = this.clientReceiver.deserialize(response, new GenericType<AMIRestDNSGeneral>(){});
                    this.jsonResults.add(this.dnsPayload);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Send DNS enable success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.dnsPayload.toString());
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Send DNS enable fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Send DNS enable fail."));
                    return false;
                }
                restartPayload.setDns_status(new BigInteger("1"));
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_RESTART_URI).setCookies(this.sessionData)).setContentType("application/json")).setRawJsonData(restartPayload)).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.clientReceiver.deserialize(response, new GenericType<AMIRestDNSGeneral>(){});
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] DNS restart success, please wait BMC reboot.");
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] DNS restart fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Send DNS restart fail."));
                    return false;
                }
            }
            case "disable": {
                Response response;
                restartPayload.setDns_status(new BigInteger("0"));
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_GENERAL_URI).setCookies(this.sessionData)).setContentType("application/json")).setRawJsonData(restartPayload)).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.dnsPayload = this.clientReceiver.deserialize(response, new GenericType<AMIRestDNSGeneral>(){});
                    this.jsonResults.add(this.dnsPayload);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Send DNS disable success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.dnsPayload.toString());
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Send DNS disable fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Send DNS disable fail."));
                    return false;
                }
                restartPayload.setDns_status(new BigInteger("1"));
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_RESTART_URI).setCookies(this.sessionData)).setContentType("application/json")).setRawJsonData(restartPayload)).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.clientReceiver.deserialize(response, new GenericType<AMIRestDNSGeneral>(){});
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] DNS restart success, please wait BMC reboot.");
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] DNS restart fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("DNS restart fail."));
                    return false;
                }
            }
            case "status": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_GENERAL_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.dnsPayload = this.clientReceiver.deserialize(response, new GenericType<AMIRestDNSGeneral>(){});
                    this.jsonResults.add(this.dnsPayload);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.dnsPayload.toString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get DNS status success.");
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get DNS status fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get DNS status fail."));
                    return false;
                }
            }
            case "gethost": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_HOST_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.dnsPayload = this.clientReceiver.deserialize(response, new GenericType<AMIRestDNSHostname>(){});
                    this.jsonResults.add(this.dnsPayload);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.dnsPayload.toString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get DNS hostname success.");
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get DNS hostname fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get DNS hostname fail."));
                    return false;
                }
            }
            case "getserver": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_SERVER_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestDNSServer>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get DNS server success.");
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get DNS server fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get DNS server fail."));
                    return false;
                }
            }
            case "getdomain": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_DOMAIN_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestDNSDomain>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get DNS domain success.");
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get DNS domain fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get DNS domain fail."));
                    return false;
                }
            }
            case "info": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.dnsPayload = this.clientReceiver.deserialize(response, new GenericType<AMIRestDNSRoot>(){});
                    this.jsonResults.add(this.dnsPayload);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.dnsPayload.toString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get DNS Info success.");
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get DNS Info fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get DNS domain fail."));
                    return false;
                }
            }
            case "setdns": {
                Response response;
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_URI).setCookies(this.sessionData)).setContentType("application/json")).setRawJsonData(this.dnsPayload)).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.dnsPayload = this.clientReceiver.deserialize(response, new GenericType<AMIRestDNSRoot>(){});
                    this.jsonResults.add(this.dnsPayload);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.dnsPayload.toString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set DNS Info success.");
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set DNS Info fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set DNS domain fail."));
                    return false;
                }
                restartPayload.setDns_status(new BigInteger("1"));
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DNS_RESTART_URI).setCookies(this.sessionData)).setContentType("application/json")).setRawJsonData(restartPayload)).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.clientReceiver.deserialize(response, new GenericType<AMIRestDNSGeneral>(){});
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] DNS restart success, please wait BMC reboot.");
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] DNS restart fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("DNS restart fail."));
                    return false;
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }
}

