/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.AMIRestNTPData;
import java.io.File;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class NTPService
extends RESTServices {
    public static final String SERVICE_NAME = "ntp";
    private static final String NTP_RESOURCE_URI = "/api/settings/date-time";
    private AMIRestNTPData ntpData;

    public NTPService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "get": {
                return true;
            }
            case "set": {
                try {
                    this.ntpData = (AMIRestNTPData)JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), restServicesOptions.getRequestPayloadType());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions servicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        RESTRequestImpl request = null;
        Response response = null;
        switch (servicesOptions.getOptionName()) {
            case "get": {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(NTP_RESOURCE_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.ntpData = this.clientReceiver.deserialize(response, new GenericType<AMIRestNTPData>(){});
                    this.jsonResults.add(this.ntpData);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get NTP data success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.ntpData.toString());
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get NTP data fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get NTP data fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
            case "set": {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(NTP_RESOURCE_URI).setRawJsonData(this.ntpData)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.ntpData = this.clientReceiver.deserialize(response, new GenericType<AMIRestNTPData>(){});
                    this.jsonResults.add(this.ntpData);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set NTP data success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.ntpData.toString());
                    boolean re = true;
                    return re;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set NTP data fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set NTP data fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }
}

