/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.raid.AMIRestRaidBBUinfo;
import Gbt.utility.rest.models.raid.AMIRestRaidControllerInfo;
import Gbt.utility.rest.models.raid.AMIRestRaidEventLogs;
import Gbt.utility.rest.models.raid.AMIRestRaidLogEventTypeAndId;
import Gbt.utility.rest.models.raid.AMIRestRaidLogicalDeviceInfo;
import Gbt.utility.rest.models.raid.AMIRestRaidPhysicalDeviceInfo;
import Gbt.utility.rest.models.raid.AMIRestRaidStorageSummary;
import Gbt.utility.rest.requests.RaidBBUInfoRequest;
import Gbt.utility.rest.requests.RaidCreateRequest;
import Gbt.utility.rest.requests.RaidDeleteRequest;
import Gbt.utility.rest.requests.RaidEventLogsRequest;
import Gbt.utility.rest.requests.RaidLogicalDeviceInfoRequest;
import Gbt.utility.rest.requests.RaidPhysicalDeviceInfoRequest;
import Gbt.utility.rest.requests.RaidRequest;
import Gbt.utility.rest.requests.RaidStorageSummaryRequest;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class RaidServices
extends RESTServices {
    public static final String SERVICE_NAME = "raid";
    private Object uploadData;

    public RaidServices(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "createvirtualdevice": {
                try {
                    this.uploadData = JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), restServicesOptions.getRequestPayloadType());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case "deletevirtualdevice": {
                try {
                    this.uploadData = JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), restServicesOptions.getRequestPayloadType());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case "getlogs": {
                try {
                    this.uploadData = JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), restServicesOptions.getRequestPayloadType());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        switch (restServicesOptions.getOptionName()) {
            case "getraidinfo": {
                RaidRequest request = ((RaidRequest.Builder)((RaidRequest.Builder)((RaidRequest.Builder)((RaidRequest.Builder)((RaidRequest.Builder)new RaidRequest.Builder().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestRaidControllerInfo>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get raid card info success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get raid card info fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get raid card info fail."));
                    return false;
                }
            }
            case "createvirtualdevice": {
                RaidCreateRequest request = ((RaidCreateRequest.Builder)((RaidCreateRequest.Builder)((RaidCreateRequest.Builder)((RaidCreateRequest.Builder)((RaidCreateRequest.Builder)((RaidCreateRequest.Builder)new RaidCreateRequest.Builder().setHttpMethods(RESTHttpMethods.POST)).setHostname(ipAddress)).setPort(this.bmcPort)).setRawJsonData(this.uploadData)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Create Vitual Drive success.");
                    this.jsonResults.add(new NullJSONData().setError(false).setMessages("Create Vitual Drive success."));
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Create Vitual Drive fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Create Vitual Drive fail."));
                    return false;
                }
            }
            case "deletevirtualdevice": {
                RaidDeleteRequest request = ((RaidDeleteRequest.Builder)((RaidDeleteRequest.Builder)((RaidDeleteRequest.Builder)((RaidDeleteRequest.Builder)((RaidDeleteRequest.Builder)((RaidDeleteRequest.Builder)new RaidDeleteRequest.Builder().setHttpMethods(RESTHttpMethods.DELETE)).setHostname(ipAddress)).setPort(this.bmcPort)).setRawJsonData(this.uploadData)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Delete Vitual Drive success.");
                    this.jsonResults.add(new NullJSONData().setError(false).setMessages("Delete Vitual Drive success."));
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Delete Vitual Drive fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Delete Vitual Drive fail."));
                    return false;
                }
            }
            case "getstoragesummary": {
                RaidStorageSummaryRequest request = ((RaidStorageSummaryRequest.Builder)((RaidStorageSummaryRequest.Builder)((RaidStorageSummaryRequest.Builder)((RaidStorageSummaryRequest.Builder)((RaidStorageSummaryRequest.Builder)new RaidStorageSummaryRequest.Builder().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestRaidStorageSummary>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get Raid Storage Summary success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get Raid Storage Summary fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get Raid Storage Summary fail."));
                    return false;
                }
            }
            case "getphysicaldeviceinfo": {
                RaidPhysicalDeviceInfoRequest request = ((RaidPhysicalDeviceInfoRequest.Builder)((RaidPhysicalDeviceInfoRequest.Builder)((RaidPhysicalDeviceInfoRequest.Builder)((RaidPhysicalDeviceInfoRequest.Builder)((RaidPhysicalDeviceInfoRequest.Builder)new RaidPhysicalDeviceInfoRequest.Builder().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestRaidPhysicalDeviceInfo>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get Raid Physical Device info success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get Raid Physical Device info fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get Raid Physical Device info fail."));
                    return false;
                }
            }
            case "getlogicaldeviceinfo": {
                RaidLogicalDeviceInfoRequest request = ((RaidLogicalDeviceInfoRequest.Builder)((RaidLogicalDeviceInfoRequest.Builder)((RaidLogicalDeviceInfoRequest.Builder)((RaidLogicalDeviceInfoRequest.Builder)((RaidLogicalDeviceInfoRequest.Builder)new RaidLogicalDeviceInfoRequest.Builder().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestRaidLogicalDeviceInfo>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get Raid Logical Device info success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get Raid Logsical Device info fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get Raid Logsical Device info fail."));
                    return false;
                }
            }
            case "getbbuinfo": {
                RaidBBUInfoRequest request = ((RaidBBUInfoRequest.Builder)((RaidBBUInfoRequest.Builder)((RaidBBUInfoRequest.Builder)((RaidBBUInfoRequest.Builder)((RaidBBUInfoRequest.Builder)new RaidBBUInfoRequest.Builder().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestRaidBBUinfo>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get Raid BBU info success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get Raid BBU info fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get Raid BBU info fail."));
                    return false;
                }
            }
            case "getlogs": {
                AMIRestRaidLogEventTypeAndId logEventTypeAndId = (AMIRestRaidLogEventTypeAndId)this.uploadData;
                RaidEventLogsRequest request = ((RaidEventLogsRequest.Builder)((RaidEventLogsRequest.Builder)((RaidEventLogsRequest.Builder)((RaidEventLogsRequest.Builder)((RaidEventLogsRequest.Builder)new RaidEventLogsRequest.Builder().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).setCtrlID(logEventTypeAndId.getCtrlId().intValue()).setEvtType(logEventTypeAndId.getEvtType().intValue()).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestRaidEventLogs>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get Raid event logs success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get Raid event logs fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get Raid event logs fail."));
                    return false;
                }
            }
            case "deletelogs": {
                RaidEventLogsRequest request = ((RaidEventLogsRequest.Builder)((RaidEventLogsRequest.Builder)((RaidEventLogsRequest.Builder)((RaidEventLogsRequest.Builder)((RaidEventLogsRequest.Builder)new RaidEventLogsRequest.Builder().setHttpMethods(RESTHttpMethods.DELETE)).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Delete Raid event logs success");
                    this.jsonResults.add(new NullJSONData().setError(false).setMessages("Delete Raid event logs success."));
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Delete Raid event logs fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Delete Raid event logs fail."));
                    return false;
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }
}

