/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.api.async;

import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.async.InboundMessageListener;
import com.veraxsystems.vxipmi.api.sol.SolEventListener;
import com.veraxsystems.vxipmi.api.sync.IpmiConnector;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.sol.SolAckState;
import com.veraxsystems.vxipmi.coding.payload.sol.SolInboundMessage;
import com.veraxsystems.vxipmi.coding.payload.sol.SolStatus;
import com.veraxsystems.vxipmi.coding.sol.SolCoder;
import com.veraxsystems.vxipmi.common.ByteBuffer;
import java.util.List;
import java.util.Set;

public class InboundSolMessageListener
implements InboundMessageListener {
    private static final int BUFFER_CAPACITY = 2048;
    private final ByteBuffer buffer = new ByteBuffer(2048);
    private final IpmiConnector connector;
    private final ConnectionHandle connectionHandle;
    private final List<SolEventListener> eventListeners;
    private SolInboundMessage waitingMessage;

    public InboundSolMessageListener(IpmiConnector connector, ConnectionHandle connectionHandle, List<SolEventListener> eventListeners) {
        this.connector = connector;
        this.connectionHandle = connectionHandle;
        this.eventListeners = eventListeners;
    }

    @Override
    public boolean isPayloadSupported(IpmiPayload payload) {
        return payload instanceof SolInboundMessage;
    }

    @Override
    public void notify(int handle, IpmiPayload payload) {
        if (this.isPayloadSupported(payload) && this.connectionHandle.getHandle() == handle) {
            Set<SolStatus> statuses;
            SolInboundMessage solPayload = (SolInboundMessage)payload;
            byte[] characterData = solPayload.getData();
            if (this.messageHasCharacterData(characterData)) {
                this.processCharacterData(solPayload, characterData);
            }
            if (this.messageHasStatuses(statuses = solPayload.getStatusField().getStatuses())) {
                this.processStatuses(statuses);
            }
        }
    }

    private void processCharacterData(SolInboundMessage solPayload, byte[] characterData) {
        if (this.noSpaceForDataInBuffer(characterData)) {
            this.sendNack(solPayload);
        } else {
            this.buffer.write(characterData);
            this.sendAck(solPayload, characterData);
        }
    }

    private void processStatuses(Set<SolStatus> statuses) {
        for (SolEventListener listener : this.eventListeners) {
            listener.processRequestEvent(statuses);
        }
    }

    private boolean noSpaceForDataInBuffer(byte[] characterData) {
        return characterData.length > this.buffer.remainingSpace();
    }

    private boolean messageHasCharacterData(byte[] characterData) {
        return characterData != null && characterData.length > 0;
    }

    private boolean messageHasStatuses(Set<SolStatus> statuses) {
        return statuses != null && !statuses.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNack(SolInboundMessage solPayload) {
        if (solPayload.getSequenceNumber() != 0) {
            try {
                SolCoder solNack = new SolCoder(solPayload.getSequenceNumber(), 0, SolAckState.NACK, this.connectionHandle.getCipherSuite());
                this.connector.sendOneWayMessage(this.connectionHandle, solNack);
                ByteBuffer byteBuffer = this.buffer;
                synchronized (byteBuffer) {
                    this.waitingMessage = solPayload;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAck(SolInboundMessage solPayload, byte[] characterData) {
        if (solPayload.getSequenceNumber() != 0) {
            try {
                SolCoder solAck = new SolCoder(solPayload.getSequenceNumber(), (byte)characterData.length, SolAckState.ACK, this.connectionHandle.getCipherSuite());
                this.connector.sendOneWayMessage(this.connectionHandle, solAck);
                ByteBuffer byteBuffer = this.buffer;
                synchronized (byteBuffer) {
                    this.waitingMessage = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sendResumeAck(SolInboundMessage solPayload) {
        try {
            SolCoder solResumeAck = new SolCoder(solPayload.getSequenceNumber(), 0, SolAckState.ACK, this.connectionHandle.getCipherSuite());
            this.connector.sendOneWayMessage(this.connectionHandle, solResumeAck);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int numberOfBytes) {
        byte[] result = this.buffer.read(numberOfBytes);
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            if (this.waitingMessage != null && this.waitingMessage.getData().length <= this.buffer.remainingSpace()) {
                this.sendResumeAck(this.waitingMessage);
            }
        }
        return result;
    }

    public int getAvailableBytesCount() {
        return this.buffer.size();
    }
}

