/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.api.sync;

import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.async.InboundMessageListener;
import com.veraxsystems.vxipmi.api.async.IpmiAsyncConnector;
import com.veraxsystems.vxipmi.api.sync.MessageListener;
import com.veraxsystems.vxipmi.coding.PayloadCoder;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.PropertiesManager;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import com.veraxsystems.vxipmi.connection.Session;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Random;

public final class IpmiConnector {
    private volatile IpmiAsyncConnector asyncConnector;
    private int retries;
    private int idleTime;
    private Random random = new Random(System.currentTimeMillis());

    public IpmiConnector(int port) throws IOException {
        this.asyncConnector = new IpmiAsyncConnector(port);
        this.retries = Integer.parseInt(PropertiesManager.getInstance().getProperty("retries"));
        this.idleTime = Integer.parseInt(PropertiesManager.getInstance().getProperty("idleTime"));
        this.asyncConnector.setRetries(this.retries);
    }

    public IpmiConnector(int port, InetAddress address) throws IOException {
        this.asyncConnector = new IpmiAsyncConnector(port, address);
        this.retries = Integer.parseInt(PropertiesManager.getInstance().getProperty("retries"));
        this.idleTime = Integer.parseInt(PropertiesManager.getInstance().getProperty("idleTime"));
        this.asyncConnector.setRetries(this.retries);
    }

    public ConnectionHandle createConnection(InetAddress address) throws IOException {
        return this.createConnection(address, 623);
    }

    public ConnectionHandle createConnection(InetAddress address, int port) throws IOException {
        return this.asyncConnector.createConnection(address, port);
    }

    public List<CipherSuite> getAvailableCipherSuites(ConnectionHandle connectionHandle) throws ConnectionException {
        return this.asyncConnector.getAvailableCipherSuites(connectionHandle);
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(ConnectionHandle connectionHandle, List<CipherSuite> cipherSuites, PrivilegeLevel requestedPrivilegeLevel) throws ConnectionException {
        return this.asyncConnector.getChannelAuthenticationCapabilities(connectionHandle, cipherSuites, requestedPrivilegeLevel);
    }

    public Session openSession(ConnectionHandle connectionHandle, String username, String password, byte[] bmcKey) throws Exception {
        return this.asyncConnector.openSession(connectionHandle, username, password, bmcKey);
    }

    public Session getExistingSessionForCriteria(InetAddress remoteAddress, int remotePort, String user) {
        return this.asyncConnector.getExistingSessionForCriteria(remoteAddress, remotePort, user);
    }

    public void closeSession(ConnectionHandle connectionHandle) throws ConnectionException {
        this.asyncConnector.closeSession(connectionHandle);
    }

    public ResponseData sendMessage(ConnectionHandle connectionHandle, PayloadCoder request) throws Exception {
        return this.sendMessage(connectionHandle, request, true);
    }

    public ResponseData sendOneWayMessage(ConnectionHandle connectionHandle, PayloadCoder request) throws Exception {
        return this.sendMessage(connectionHandle, request, false);
    }

    public ResponseData retryMessage(ConnectionHandle connectionHandle, byte tag, PayloadType messagePayloadType) throws Exception {
        MessageListener listener = new MessageListener(connectionHandle);
        this.asyncConnector.registerListener(listener);
        int retryResult = this.asyncConnector.retry(connectionHandle, tag, messagePayloadType);
        ResponseData data = retryResult != -1 ? listener.waitForAnswer(tag) : null;
        this.asyncConnector.unregisterListener(listener);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseData sendMessage(ConnectionHandle connectionHandle, PayloadCoder request, boolean waitForResponse) throws Exception {
        MessageListener listener = new MessageListener(connectionHandle);
        this.asyncConnector.registerListener(listener);
        try {
            ResponseData responseData = this.sendThroughAsyncConnector(request, connectionHandle, listener, waitForResponse);
            return responseData;
        }
        finally {
            this.asyncConnector.unregisterListener(listener);
        }
    }

    private ResponseData sendThroughAsyncConnector(PayloadCoder request, ConnectionHandle connectionHandle, MessageListener listener, boolean waitForResponse) throws Exception {
        ResponseData responseData = null;
        int tries = 0;
        int tag = -1;
        while (responseData == null) {
            try {
                ++tries;
                if (tag >= 0) {
                    tag = this.asyncConnector.retry(connectionHandle, tag, request.getSupportedPayloadType());
                }
                if (tag < 0) {
                    tag = this.asyncConnector.sendMessage(connectionHandle, request, !waitForResponse);
                }
                if (!waitForResponse && request.getSupportedPayloadType() != PayloadType.Ipmi) break;
                responseData = listener.waitForAnswer(tag);
                break;
            }
            catch (IPMIException ipmie) {
                this.handleErrorResponse(tries, ipmie);
            }
            catch (Exception e) {
                this.handleRetriesWhenException(tries, e);
            }
        }
        return responseData;
    }

    private void handleRetriesWhenException(int tries, Exception e) throws Exception {
        if (tries > this.retries) {
            throw e;
        }
        Thread.sleep(this.random.nextLong() % (long)(this.idleTime / 2) + (long)(this.idleTime / 2));
    }

    private void handleErrorResponse(int tries, IPMIException ipmie) throws Exception {
        if (ipmie.getCompletionCode() != CompletionCode.InitializationInProgress && ipmie.getCompletionCode() != CompletionCode.InsufficientResources && ipmie.getCompletionCode() != CompletionCode.NodeBusy && ipmie.getCompletionCode() != CompletionCode.Timeout) {
            throw ipmie;
        }
        this.handleRetriesWhenException(tries, ipmie);
    }

    public void registerIncomingMessageListener(InboundMessageListener listener) {
        this.asyncConnector.registerIncomingPayloadListener(listener);
    }

    public void closeConnection(ConnectionHandle handle) {
        this.asyncConnector.closeConnection(handle);
    }

    public void tearDown() {
        this.asyncConnector.tearDown();
    }

    public void setTimeout(ConnectionHandle handle, int timeout) {
        this.asyncConnector.setTimeout(handle, timeout);
    }

    public int getRetries() {
        return this.retries;
    }

    public int sendRmcpPingMessage(ConnectionHandle connectionHandle) throws ConnectionException {
        return this.asyncConnector.sendRmcpPingMessage(connectionHandle);
    }
}

