/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.fru;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.fru.BaseUnit;
import com.veraxsystems.vxipmi.coding.commands.fru.ReadFruDataResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class ReadFruData
extends IpmiCommandCoder {
    private int offset;
    private int size;
    private int fruId;

    public ReadFruData(int fruId, BaseUnit unit, int offset, int countToRead) {
        if (countToRead > 255) {
            throw new IllegalArgumentException("Count to read cannot exceed 255");
        }
        if (fruId > 255) {
            throw new IllegalArgumentException("FRU ID cannot exceed 255");
        }
        this.offset = offset * unit.getSize();
        this.size = countToRead * unit.getSize();
        this.fruId = fruId;
    }

    public ReadFruData(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, int fruId, BaseUnit unit, int offset, int countToRead) {
        super(version, cipherSuite, authenticationType);
        if (countToRead > 255) {
            throw new IllegalArgumentException("Count to read cannot exceed 255");
        }
        if (fruId > 255) {
            throw new IllegalArgumentException("FRU ID cannot exceed 255");
        }
        this.offset = offset * unit.getSize();
        this.size = countToRead * unit.getSize();
        this.fruId = fruId;
    }

    @Override
    public byte getCommandCode() {
        return 17;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.StorageRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) {
        byte[] payload = new byte[4];
        payload[0] = TypeConverter.intToByte(this.fruId);
        byte[] buffer = TypeConverter.intToLittleEndianByteArray(this.offset);
        payload[1] = buffer[0];
        payload[2] = buffer[1];
        payload[3] = TypeConverter.intToByte(this.size);
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), payload, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IllegalArgumentException, IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get SDR Repository Info command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw == null) {
            throw new IllegalArgumentException("Invalid response payload length");
        }
        ReadFruDataResponseData responseData = new ReadFruDataResponseData();
        int size = TypeConverter.byteToInt(raw[0]);
        byte[] fruData = new byte[size];
        System.arraycopy(raw, 1, fruData, 0, size);
        responseData.setFruData(fruData);
        return responseData;
    }
}

