/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.common;

public class ByteBuffer {
    private byte[] buffer;
    private int readMarker;
    private int writeMarker;

    public ByteBuffer(int capacity) {
        this.buffer = capacity <= 0 ? new byte[2048] : new byte[capacity];
        this.readMarker = 0;
        this.writeMarker = 0;
    }

    public synchronized int write(byte[] bytes) {
        if (this.shouldRewindBuffer(bytes)) {
            this.rewind();
        }
        int actualBytesToWrite = Math.min(bytes.length, this.buffer.length - this.writeMarker);
        System.arraycopy(bytes, 0, this.buffer, this.writeMarker, actualBytesToWrite);
        this.writeMarker += actualBytesToWrite;
        return actualBytesToWrite;
    }

    public synchronized byte[] read(int numberOfBytes) {
        int actualNumberOfBytes = Math.min(numberOfBytes, this.size());
        byte[] result = new byte[actualNumberOfBytes];
        System.arraycopy(this.buffer, this.readMarker, result, 0, result.length);
        this.readMarker += actualNumberOfBytes;
        return result;
    }

    public synchronized int size() {
        return this.writeMarker - this.readMarker;
    }

    public synchronized int capacity() {
        return this.buffer.length;
    }

    public synchronized int remainingSpace() {
        return this.capacity() - this.size();
    }

    private boolean shouldRewindBuffer(byte[] bytesToWrite) {
        return bytesToWrite.length > this.buffer.length - this.writeMarker && this.readMarker > 0;
    }

    private void rewind() {
        int currentSize = this.size();
        byte[] newBuffer = new byte[this.capacity()];
        System.arraycopy(this.buffer, this.readMarker, newBuffer, 0, currentSize);
        this.buffer = newBuffer;
        this.readMarker = 0;
        this.writeMarker = currentSize;
    }
}

