/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.connection;

import com.veraxsystems.vxipmi.coding.PayloadCoder;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilities;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanMessage;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.connection.Connection;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import com.veraxsystems.vxipmi.connection.MessageHandler;
import com.veraxsystems.vxipmi.sm.StateMachine;
import com.veraxsystems.vxipmi.sm.events.Sendv20Message;
import java.util.HashMap;
import java.util.Map;

public class IpmiMessageHandler
extends MessageHandler {
    private Map<Integer, Integer> sequenceCountMap = new HashMap<Integer, Integer>();

    public IpmiMessageHandler(Connection connection, int timeout) {
        super(connection, timeout, 1, 63, "Raw");
    }

    @Override
    public int sendMessage(PayloadCoder payloadCoder, StateMachine stateMachine, int sessionId, boolean isOneWay) throws ConnectionException {
        this.validateSessionState(stateMachine);
        int seq = this.messageQueue.add(payloadCoder);
        if (this.connection.isKeepAlive()) {
            this.sequenceCountMap.put(seq, 0);
        }
        if (seq > 0) {
            stateMachine.doTransition(new Sendv20Message(payloadCoder, sessionId, seq, this.connection.getNextSessionSequenceNumber()));
        }
        return seq;
    }

    @Override
    protected void handleIncomingMessageInternal(Ipmiv20Message message) {
        if (message.getPayload() instanceof IpmiLanMessage) {
            IpmiLanMessage lanMessagePayload = (IpmiLanMessage)message.getPayload();
            PayloadCoder coder = this.messageQueue.getMessageFromQueue(lanMessagePayload.getSequenceNumber());
            byte tag = lanMessagePayload.getSequenceNumber();
            if (coder == null) {
                return;
            }
            if (coder.getClass() == GetChannelAuthenticationCapabilities.class) {
                this.messageQueue.remove(tag);
            } else if (!this.connection.isKeepAlive() || this.connection.isKeepAlive() && this.sequenceCountMap.containsKey(tag) && this.sequenceCountMap.get(tag) == 1) {
                try {
                    ResponseData responseData = coder.getResponseData(message);
                    this.connection.notifyResponseListeners(this.connection.getHandle(), tag, responseData, null);
                }
                catch (Exception e) {
                    this.connection.notifyResponseListeners(this.connection.getHandle(), tag, null, e);
                }
                this.messageQueue.remove(lanMessagePayload.getSequenceNumber());
            } else if (this.sequenceCountMap.containsKey(tag)) {
                int count = this.sequenceCountMap.get(tag);
                this.sequenceCountMap.put(Integer.valueOf(tag), ++count);
            }
        }
    }
}

