/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.connection;

import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.sync.IpmiConnector;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.connection.Session;
import com.veraxsystems.vxipmi.connection.SessionException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class SessionManager {
    private static Integer sessionId = 100;
    private final ConcurrentHashMap<Integer, Session> sessionsPerConnectionHandle = new ConcurrentHashMap();

    public static synchronized int generateSessionId() {
        Integer n = sessionId = Integer.valueOf(sessionId % 0x1FFFFFFF);
        Integer n2 = sessionId = Integer.valueOf(sessionId + 1);
        return n;
    }

    public static Session establishSession(IpmiConnector connector, String remoteHost, int remotePort, String user, String password) throws SessionException {
        ConnectionHandle handle = null;
        try {
            handle = connector.createConnection(InetAddress.getByName(remoteHost), remotePort);
            List<CipherSuite> availableCipherSuites = connector.getAvailableCipherSuites(handle);
            connector.getChannelAuthenticationCapabilities(handle, availableCipherSuites, PrivilegeLevel.Administrator);
            return connector.openSession(handle, user, password, null);
        }
        catch (Exception e) {
            SessionManager.closeConnection(connector, handle);
            throw new SessionException("Cannot create new session due to exception", e);
        }
    }

    private static void closeConnection(IpmiConnector connector, ConnectionHandle handle) {
        try {
            if (connector != null && handle != null) {
                connector.closeSession(handle);
                connector.closeConnection(handle);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Session registerSession(int sessionId, ConnectionHandle connectionHandle) {
        if (connectionHandle.getUser() == null || connectionHandle.getRemoteAddress() == null) {
            throw new IllegalArgumentException("Given connection handle is incomplete (lacks user or remote address)");
        }
        Session newSession = new Session(sessionId, connectionHandle);
        Session currentSession = this.sessionsPerConnectionHandle.putIfAbsent(connectionHandle.getHandle(), newSession);
        return currentSession != null ? currentSession : newSession;
    }

    public void unregisterSession(ConnectionHandle connectionHandle) {
        this.sessionsPerConnectionHandle.remove(connectionHandle.getHandle());
    }

    public Session getSessionForCriteria(InetAddress remoteAddress, int remotePort, String user) {
        for (Session session : this.sessionsPerConnectionHandle.values()) {
            ConnectionHandle sessionConnectionHandle = session.getConnectionHandle();
            if (!sessionConnectionHandle.getUser().equals(user) || !sessionConnectionHandle.getRemoteAddress().equals(remoteAddress) || sessionConnectionHandle.getRemotePort() != remotePort) continue;
            return session;
        }
        return null;
    }
}

