/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.transport;

import com.veraxsystems.vxipmi.transport.Messenger;
import com.veraxsystems.vxipmi.transport.UdpListener;
import com.veraxsystems.vxipmi.transport.UdpMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class UdpMessenger
extends Thread
implements Messenger {
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private static final AtomicInteger sentPackets = new AtomicInteger(0);
    private static final int DEFAULTBUFFERSIZE = 512;
    private int port;
    private DatagramSocket socket;
    private List<UdpListener> listeners;
    private boolean closing = false;
    private int bufferSize;

    public UdpMessenger(int port) throws SocketException, UnknownHostException {
        this(port, InetAddress.getByName(DEFAULT_ADDRESS));
    }

    public UdpMessenger(int port, InetAddress address) throws SocketException {
        this.port = port;
        this.listeners = new ArrayList<UdpListener>();
        this.bufferSize = 512;
        this.socket = new DatagramSocket(this.port, address);
        this.socket.setSoTimeout(0);
        this.setName("IPMI UDP Listener [" + address.getHostAddress() + ":" + this.socket.getLocalPort() + "]");
        this.start();
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        boolean run = true;
        while (run) {
            DatagramPacket response = new DatagramPacket(new byte[512], 512);
            try {
                this.socket.receive(response);
                UdpMessage message = new UdpMessage();
                message.setAddress(response.getAddress());
                message.setPort(response.getPort());
                byte[] buffer = new byte[response.getLength()];
                System.arraycopy(response.getData(), 0, buffer, 0, buffer.length);
                message.setMessage(buffer);
                List<UdpListener> list = this.listeners;
                synchronized (list) {
                    for (UdpListener listener : this.listeners) {
                        if (listener == null) continue;
                        listener.notifyMessage(message);
                    }
                }
            }
            catch (IOException ioe) {
                if (!this.closing) continue;
                run = false;
            }
            finally {
                if (!this.socket.isClosed()) continue;
                run = false;
            }
        }
    }

    @Override
    public void closeConnection() {
        this.closing = true;
        this.socket.close();
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(UdpListener listener) {
        List<UdpListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(UdpListener listener) {
        List<UdpListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public static int getSentPackets() {
        return sentPackets.get();
    }

    @Override
    public synchronized void send(UdpMessage message) throws IOException {
        DatagramPacket packet = new DatagramPacket(message.getMessage(), message.getMessage().length, message.getAddress(), message.getPort());
        this.socket.send(packet);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException ie) {
            Thread.yield();
        }
        sentPackets.incrementAndGet();
    }
}

