/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.GouraudShadingContext;
import org.apache.pdfbox.pdmodel.graphics.shading.GouraudTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType5;
import org.apache.pdfbox.pdmodel.graphics.shading.Vertex;
import org.apache.pdfbox.util.Matrix;

public class Type5ShadingContext
extends GouraudShadingContext {
    private static final Log LOG = LogFactory.getLog(Type5ShadingContext.class);

    public Type5ShadingContext(PDShadingType5 shadingType5, ColorModel colorModelValue, AffineTransform xform, Matrix ctm, int pageHeight) throws IOException {
        super(shadingType5, colorModelValue, xform, ctm, pageHeight);
        LOG.debug((Object)"Type5ShadingContext");
        this.bitsPerColorComponent = shadingType5.getBitsPerComponent();
        LOG.debug((Object)("bitsPerColorComponent: " + this.bitsPerColorComponent));
        this.bitsPerCoordinate = shadingType5.getBitsPerCoordinate();
        LOG.debug((Object)(Math.pow(2.0, this.bitsPerCoordinate) - 1.0));
        long maxSrcCoord = (long)Math.pow(2.0, this.bitsPerCoordinate) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.bitsPerColorComponent) - 1L;
        LOG.debug((Object)("maxSrcCoord: " + maxSrcCoord));
        LOG.debug((Object)("maxSrcColor: " + maxSrcColor));
        COSDictionary cosDictionary = shadingType5.getCOSDictionary();
        COSStream cosStream = (COSStream)cosDictionary;
        COSArray decode = (COSArray)cosDictionary.getDictionaryObject(COSName.DECODE);
        LOG.debug((Object)("decode: " + decode));
        PDRange rangeX = shadingType5.getDecodeForParameter(0);
        PDRange rangeY = shadingType5.getDecodeForParameter(1);
        LOG.debug((Object)("rangeX: " + rangeX.getMin() + ", " + rangeX.getMax()));
        LOG.debug((Object)("rangeY: " + rangeY.getMin() + ", " + rangeY.getMax()));
        PDRange[] colRangeTab = new PDRange[this.numberOfColorComponents];
        for (int i = 0; i < this.numberOfColorComponents; ++i) {
            colRangeTab[i] = shadingType5.getDecodeForParameter(2 + i);
        }
        LOG.debug((Object)("bitsPerCoordinate: " + this.bitsPerCoordinate));
        COSArray bg = shadingType5.getBackground();
        if (bg != null) {
            this.background = bg.toFloatArray();
        }
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(cosStream.getUnfilteredStream());
        int verticesPerRow = shadingType5.getVerticesPerRow();
        LOG.debug((Object)("verticesPerRow" + verticesPerRow));
        try {
            ArrayList<Object> prevVertexRow = new ArrayList();
            while (true) {
                ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
                for (int row = 0; row < verticesPerRow; ++row) {
                    vertexList.add(this.readVertex(mciis, (byte)0, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRangeTab));
                }
                this.transformVertices(vertexList, ctm, xform, pageHeight);
                if (!prevVertexRow.isEmpty()) {
                    for (int vj = 0; vj < vertexList.size() - 1; ++vj) {
                        Vertex vij = (Vertex)prevVertexRow.get(vj);
                        Vertex vijplus1 = (Vertex)prevVertexRow.get(vj + 1);
                        Vertex viplus1j = vertexList.get(vj);
                        Vertex viplus1jplus1 = vertexList.get(vj + 1);
                        GouraudTriangle g = new GouraudTriangle(vij.point, vij.color, vijplus1.point, vijplus1.color, viplus1j.point, viplus1j.color);
                        if (!g.isEmpty()) {
                            this.triangleList.add(g);
                        } else {
                            LOG.debug((Object)"triangle is empty!");
                        }
                        g = new GouraudTriangle(vijplus1.point, vijplus1.color, viplus1j.point, viplus1j.color, viplus1jplus1.point, viplus1jplus1.color);
                        if (!g.isEmpty()) {
                            this.triangleList.add(g);
                            continue;
                        }
                        LOG.debug((Object)"triangle is empty!");
                    }
                }
                prevVertexRow = vertexList;
            }
        }
        catch (EOFException ex) {
            LOG.debug((Object)"EOF");
            mciis.close();
            return;
        }
    }

    public void dispose() {
        super.dispose();
    }
}

