/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.android;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class FixedAndroidLogHandler
extends Handler {
    private static final Formatter THE_FORMATTER = new Formatter(){

        @Override
        public String format(LogRecord r) {
            Throwable thrown = r.getThrown();
            if (thrown != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                sw.write(r.getMessage());
                sw.write("\n");
                thrown.printStackTrace(pw);
                pw.flush();
                return sw.toString();
            }
            return r.getMessage();
        }
    };

    public FixedAndroidLogHandler() {
        this.setFormatter(THE_FORMATTER);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        try {
            int level = FixedAndroidLogHandler.getAndroidLevel(record.getLevel());
            String tag = record.getLoggerName();
            if (tag == null) {
                tag = "null";
            } else {
                int length = tag.length();
                if (length > 23) {
                    int lastPeriod = tag.lastIndexOf(".");
                    tag = length - lastPeriod - 1 <= 23 ? tag.substring(lastPeriod + 1) : tag.substring(tag.length() - 23);
                }
            }
            String message = this.getFormatter().format(record);
            Log.println((int)level, (String)tag, (String)message);
        }
        catch (RuntimeException e) {
            Log.e((String)"AndroidHandler", (String)"Error logging message.", (Throwable)e);
        }
    }

    static int getAndroidLevel(Level level) {
        int value = level.intValue();
        if (value >= 1000) {
            return 6;
        }
        if (value >= 900) {
            return 5;
        }
        if (value >= 800) {
            return 4;
        }
        return 3;
    }
}

