/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.controlpoint;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.fourthline.cling.UpnpServiceConfiguration;
import org.fourthline.cling.controlpoint.ActionCallback;
import org.fourthline.cling.controlpoint.ControlPoint;
import org.fourthline.cling.controlpoint.SubscriptionCallback;
import org.fourthline.cling.controlpoint.event.ExecuteAction;
import org.fourthline.cling.controlpoint.event.Search;
import org.fourthline.cling.model.message.header.MXHeader;
import org.fourthline.cling.model.message.header.STAllHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.protocol.ProtocolFactory;
import org.fourthline.cling.registry.Registry;

@ApplicationScoped
public class ControlPointImpl
implements ControlPoint {
    private static Logger log = Logger.getLogger(ControlPointImpl.class.getName());
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;
    protected Registry registry;

    protected ControlPointImpl() {
    }

    @Inject
    public ControlPointImpl(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory, Registry registry) {
        log.fine("Creating ControlPoint: " + this.getClass().getName());
        this.configuration = configuration;
        this.protocolFactory = protocolFactory;
        this.registry = registry;
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    public void search(@Observes Search search) {
        this.search(search.getSearchType(), search.getMxSeconds());
    }

    @Override
    public void search() {
        this.search(new STAllHeader(), MXHeader.DEFAULT_VALUE);
    }

    @Override
    public void search(UpnpHeader searchType) {
        this.search(searchType, MXHeader.DEFAULT_VALUE);
    }

    @Override
    public void search(int mxSeconds) {
        this.search(new STAllHeader(), mxSeconds);
    }

    @Override
    public void search(UpnpHeader searchType, int mxSeconds) {
        log.fine("Sending asynchronous search for: " + searchType.getString());
        this.getConfiguration().getAsyncProtocolExecutor().execute(this.getProtocolFactory().createSendingSearch(searchType, mxSeconds));
    }

    public void execute(ExecuteAction executeAction) {
        this.execute(executeAction.getCallback());
    }

    @Override
    public Future execute(ActionCallback callback) {
        log.fine("Invoking action in background: " + callback);
        callback.setControlPoint(this);
        ExecutorService executor = this.getConfiguration().getSyncProtocolExecutorService();
        return executor.submit(callback);
    }

    @Override
    public void execute(SubscriptionCallback callback) {
        log.fine("Invoking subscription in background: " + callback);
        callback.setControlPoint(this);
        this.getConfiguration().getSyncProtocolExecutorService().execute(callback);
    }
}

