/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.controlpoint;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.controlpoint.ControlPoint;
import org.fourthline.cling.model.UnsupportedDataException;
import org.fourthline.cling.model.gena.CancelReason;
import org.fourthline.cling.model.gena.GENASubscription;
import org.fourthline.cling.model.gena.LocalGENASubscription;
import org.fourthline.cling.model.gena.RemoteGENASubscription;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.DeviceIdentity;
import org.fourthline.cling.model.meta.LocalService;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.protocol.ProtocolCreationException;
import org.fourthline.cling.protocol.sync.SendingSubscribe;
import org.seamless.util.Exceptions;

public abstract class SubscriptionCallback
implements Runnable {
    protected static Logger log = Logger.getLogger(SubscriptionCallback.class.getName());
    protected final Service service;
    protected final Integer requestedDurationSeconds;
    private ControlPoint controlPoint;
    private GENASubscription subscription;

    protected SubscriptionCallback(Service service) {
        this.service = service;
        this.requestedDurationSeconds = 1800;
    }

    protected SubscriptionCallback(Service service, int requestedDurationSeconds) {
        this.service = service;
        this.requestedDurationSeconds = requestedDurationSeconds;
    }

    public Service getService() {
        return this.service;
    }

    public synchronized ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public synchronized void setControlPoint(ControlPoint controlPoint) {
        this.controlPoint = controlPoint;
    }

    public synchronized GENASubscription getSubscription() {
        return this.subscription;
    }

    public synchronized void setSubscription(GENASubscription subscription) {
        this.subscription = subscription;
    }

    @Override
    public synchronized void run() {
        if (this.getControlPoint() == null) {
            throw new IllegalStateException("Callback must be executed through ControlPoint");
        }
        if (this.getService() instanceof LocalService) {
            this.establishLocalSubscription((LocalService)this.service);
        } else if (this.getService() instanceof RemoteService) {
            this.establishRemoteSubscription((RemoteService)this.service);
        }
    }

    private void establishLocalSubscription(LocalService service) {
        if (this.getControlPoint().getRegistry().getLocalDevice(((DeviceIdentity)((Device)service.getDevice()).getIdentity()).getUdn(), false) == null) {
            log.fine("Local device service is currently not registered, failing subscription immediately");
            this.failed(null, null, new IllegalStateException("Local device is not registered"));
            return;
        }
        LocalGENASubscription localSubscription = null;
        try {
            localSubscription = new LocalGENASubscription(service, Integer.MAX_VALUE, Collections.EMPTY_LIST){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void failed(Exception ex) {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.setSubscription(null);
                        SubscriptionCallback.this.failed(null, null, ex);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void established() {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.setSubscription(this);
                        SubscriptionCallback.this.established(this);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void ended(CancelReason reason) {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.setSubscription(null);
                        SubscriptionCallback.this.ended(this, reason, null);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void eventReceived() {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        log.fine("Local service state updated, notifying callback, sequence is: " + this.getCurrentSequence());
                        SubscriptionCallback.this.eventReceived(this);
                        this.incrementSequence();
                    }
                }
            };
            log.fine("Local device service is currently registered, also registering subscription");
            this.getControlPoint().getRegistry().addLocalSubscription(localSubscription);
            log.fine("Notifying subscription callback of local subscription availablity");
            localSubscription.establish();
            log.fine("Simulating first initial event for local subscription callback, sequence: " + localSubscription.getCurrentSequence());
            this.eventReceived(localSubscription);
            localSubscription.incrementSequence();
            log.fine("Starting to monitor state changes of local service");
            localSubscription.registerOnService();
        }
        catch (Exception ex) {
            log.fine("Local callback creation failed: " + ex.toString());
            log.log(Level.FINE, "Exception root cause: ", Exceptions.unwrap((Throwable)ex));
            if (localSubscription != null) {
                this.getControlPoint().getRegistry().removeLocalSubscription(localSubscription);
            }
            this.failed(localSubscription, null, ex);
        }
    }

    private void establishRemoteSubscription(RemoteService service) {
        SendingSubscribe protocol;
        RemoteGENASubscription remoteSubscription = new RemoteGENASubscription(service, this.requestedDurationSeconds){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(UpnpResponse responseStatus) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.setSubscription(null);
                    SubscriptionCallback.this.failed(this, responseStatus, null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void established() {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.setSubscription(this);
                    SubscriptionCallback.this.established(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ended(CancelReason reason, UpnpResponse responseStatus) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.setSubscription(null);
                    SubscriptionCallback.this.ended(this, reason, responseStatus);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eventReceived() {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.eventReceived(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eventsMissed(int numberOfMissedEvents) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.eventsMissed(this, numberOfMissedEvents);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidMessage(UnsupportedDataException ex) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.invalidMessage(this, ex);
                }
            }
        };
        try {
            protocol = this.getControlPoint().getProtocolFactory().createSendingSubscribe(remoteSubscription);
        }
        catch (ProtocolCreationException ex) {
            this.failed(this.subscription, null, ex);
            return;
        }
        protocol.run();
    }

    public synchronized void end() {
        if (this.subscription == null) {
            return;
        }
        if (this.subscription instanceof LocalGENASubscription) {
            this.endLocalSubscription((LocalGENASubscription)this.subscription);
        } else if (this.subscription instanceof RemoteGENASubscription) {
            this.endRemoteSubscription((RemoteGENASubscription)this.subscription);
        }
    }

    private void endLocalSubscription(LocalGENASubscription subscription) {
        log.fine("Removing local subscription and ending it in callback: " + subscription);
        this.getControlPoint().getRegistry().removeLocalSubscription(subscription);
        subscription.end(null);
    }

    private void endRemoteSubscription(RemoteGENASubscription subscription) {
        log.fine("Ending remote subscription: " + subscription);
        this.getControlPoint().getConfiguration().getSyncProtocolExecutorService().execute(this.getControlPoint().getProtocolFactory().createSendingUnsubscribe(subscription));
    }

    protected void failed(GENASubscription subscription, UpnpResponse responseStatus, Exception exception) {
        this.failed(subscription, responseStatus, exception, SubscriptionCallback.createDefaultFailureMessage(responseStatus, exception));
    }

    protected abstract void failed(GENASubscription var1, UpnpResponse var2, Exception var3, String var4);

    protected abstract void established(GENASubscription var1);

    protected abstract void ended(GENASubscription var1, CancelReason var2, UpnpResponse var3);

    protected abstract void eventReceived(GENASubscription var1);

    protected abstract void eventsMissed(GENASubscription var1, int var2);

    public static String createDefaultFailureMessage(UpnpResponse responseStatus, Exception exception) {
        String message = "Subscription failed: ";
        message = responseStatus != null ? message + " HTTP response was: " + responseStatus.getResponseDetails() : (exception != null ? message + " Exception occured: " + exception : message + " No response received.");
        return message;
    }

    protected void invalidMessage(RemoteGENASubscription remoteGENASubscription, UnsupportedDataException ex) {
        log.info("Invalid event message received, causing: " + ex);
        if (log.isLoggable(Level.FINE)) {
            log.fine("------------------------------------------------------------------------------");
            log.fine(ex.getData() != null ? ex.getData().toString() : "null");
            log.fine("------------------------------------------------------------------------------");
        }
    }

    public String toString() {
        return "(SubscriptionCallback) " + this.getService();
    }
}

