/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.meta;

import java.net.InetAddress;
import java.net.URL;
import org.fourthline.cling.model.ModelUtil;
import org.fourthline.cling.model.message.discovery.IncomingNotificationRequest;
import org.fourthline.cling.model.message.discovery.IncomingSearchResponse;
import org.fourthline.cling.model.meta.DeviceIdentity;
import org.fourthline.cling.model.types.UDN;

public class RemoteDeviceIdentity
extends DeviceIdentity {
    private final URL descriptorURL;
    private final byte[] interfaceMacAddress;
    private final InetAddress discoveredOnLocalAddress;

    public RemoteDeviceIdentity(UDN udn, RemoteDeviceIdentity template) {
        this(udn, template.getMaxAgeSeconds(), template.getDescriptorURL(), template.getInterfaceMacAddress(), template.getDiscoveredOnLocalAddress());
    }

    public RemoteDeviceIdentity(UDN udn, Integer maxAgeSeconds, URL descriptorURL, byte[] interfaceMacAddress, InetAddress discoveredOnLocalAddress) {
        super(udn, maxAgeSeconds);
        this.descriptorURL = descriptorURL;
        this.interfaceMacAddress = interfaceMacAddress;
        this.discoveredOnLocalAddress = discoveredOnLocalAddress;
    }

    public RemoteDeviceIdentity(IncomingNotificationRequest notificationRequest) {
        this(notificationRequest.getUDN(), notificationRequest.getMaxAge(), notificationRequest.getLocationURL(), notificationRequest.getInterfaceMacHeader(), notificationRequest.getLocalAddress());
    }

    public RemoteDeviceIdentity(IncomingSearchResponse searchResponse) {
        this(searchResponse.getRootDeviceUDN(), searchResponse.getMaxAge(), searchResponse.getLocationURL(), searchResponse.getInterfaceMacHeader(), searchResponse.getLocalAddress());
    }

    public URL getDescriptorURL() {
        return this.descriptorURL;
    }

    public byte[] getInterfaceMacAddress() {
        return this.interfaceMacAddress;
    }

    public InetAddress getDiscoveredOnLocalAddress() {
        return this.discoveredOnLocalAddress;
    }

    public byte[] getWakeOnLANBytes() {
        int i;
        if (this.getInterfaceMacAddress() == null) {
            return null;
        }
        byte[] bytes = new byte[6 + 16 * this.getInterfaceMacAddress().length];
        for (i = 0; i < 6; ++i) {
            bytes[i] = -1;
        }
        for (i = 6; i < bytes.length; i += this.getInterfaceMacAddress().length) {
            System.arraycopy(this.getInterfaceMacAddress(), 0, bytes, i, this.getInterfaceMacAddress().length);
        }
        return bytes;
    }

    @Override
    public String toString() {
        if (ModelUtil.ANDROID_RUNTIME) {
            return "(RemoteDeviceIdentity) UDN: " + this.getUdn() + ", Descriptor: " + this.getDescriptorURL();
        }
        return "(" + this.getClass().getSimpleName() + ") UDN: " + this.getUdn() + ", Descriptor: " + this.getDescriptorURL();
    }
}

