/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.NetworkAddress;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.gena.LocalGENASubscription;
import org.fourthline.cling.model.gena.RemoteGENASubscription;
import org.fourthline.cling.model.message.IncomingDatagramMessage;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.model.types.InvalidValueException;
import org.fourthline.cling.model.types.NamedServiceType;
import org.fourthline.cling.model.types.NotificationSubtype;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.protocol.ProtocolCreationException;
import org.fourthline.cling.protocol.ProtocolFactory;
import org.fourthline.cling.protocol.ReceivingAsync;
import org.fourthline.cling.protocol.ReceivingSync;
import org.fourthline.cling.protocol.async.ReceivingNotification;
import org.fourthline.cling.protocol.async.ReceivingSearch;
import org.fourthline.cling.protocol.async.ReceivingSearchResponse;
import org.fourthline.cling.protocol.async.SendingNotificationAlive;
import org.fourthline.cling.protocol.async.SendingNotificationByebye;
import org.fourthline.cling.protocol.async.SendingSearch;
import org.fourthline.cling.protocol.sync.ReceivingAction;
import org.fourthline.cling.protocol.sync.ReceivingEvent;
import org.fourthline.cling.protocol.sync.ReceivingRetrieval;
import org.fourthline.cling.protocol.sync.ReceivingSubscribe;
import org.fourthline.cling.protocol.sync.ReceivingUnsubscribe;
import org.fourthline.cling.protocol.sync.SendingAction;
import org.fourthline.cling.protocol.sync.SendingEvent;
import org.fourthline.cling.protocol.sync.SendingRenewal;
import org.fourthline.cling.protocol.sync.SendingSubscribe;
import org.fourthline.cling.protocol.sync.SendingUnsubscribe;
import org.fourthline.cling.transport.RouterException;

@ApplicationScoped
public class ProtocolFactoryImpl
implements ProtocolFactory {
    private static final Logger log = Logger.getLogger(ProtocolFactory.class.getName());
    protected final UpnpService upnpService;

    protected ProtocolFactoryImpl() {
        this.upnpService = null;
    }

    @Inject
    public ProtocolFactoryImpl(UpnpService upnpService) {
        log.fine("Creating ProtocolFactory: " + this.getClass().getName());
        this.upnpService = upnpService;
    }

    @Override
    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public ReceivingAsync createReceivingAsync(IncomingDatagramMessage message) throws ProtocolCreationException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating protocol for incoming asynchronous: " + message);
        }
        if (message.getOperation() instanceof UpnpRequest) {
            IncomingDatagramMessage incomingRequest = message;
            switch (((UpnpRequest)incomingRequest.getOperation()).getMethod()) {
                case NOTIFY: {
                    return this.isByeBye(incomingRequest) || this.isSupportedServiceAdvertisement(incomingRequest) ? this.createReceivingNotification(incomingRequest) : null;
                }
                case MSEARCH: {
                    return this.createReceivingSearch(incomingRequest);
                }
            }
        } else if (message.getOperation() instanceof UpnpResponse) {
            IncomingDatagramMessage incomingResponse = message;
            return this.isSupportedServiceAdvertisement(incomingResponse) ? this.createReceivingSearchResponse(incomingResponse) : null;
        }
        throw new ProtocolCreationException("Protocol for incoming datagram message not found: " + message);
    }

    protected ReceivingAsync createReceivingNotification(IncomingDatagramMessage<UpnpRequest> incomingRequest) {
        return new ReceivingNotification(this.getUpnpService(), incomingRequest);
    }

    protected ReceivingAsync createReceivingSearch(IncomingDatagramMessage<UpnpRequest> incomingRequest) {
        return new ReceivingSearch(this.getUpnpService(), incomingRequest);
    }

    protected ReceivingAsync createReceivingSearchResponse(IncomingDatagramMessage<UpnpResponse> incomingResponse) {
        return new ReceivingSearchResponse(this.getUpnpService(), incomingResponse);
    }

    protected boolean isByeBye(IncomingDatagramMessage message) {
        String ntsHeader = message.getHeaders().getFirstHeader(UpnpHeader.Type.NTS.getHttpName());
        return ntsHeader != null && ntsHeader.equals(NotificationSubtype.BYEBYE.getHeaderString());
    }

    protected boolean isSupportedServiceAdvertisement(IncomingDatagramMessage message) {
        ServiceType[] exclusiveServiceTypes = this.getUpnpService().getConfiguration().getExclusiveServiceTypes();
        if (exclusiveServiceTypes == null) {
            return false;
        }
        if (exclusiveServiceTypes.length == 0) {
            return true;
        }
        String usnHeader = message.getHeaders().getFirstHeader(UpnpHeader.Type.USN.getHttpName());
        if (usnHeader == null) {
            return false;
        }
        try {
            NamedServiceType nst = NamedServiceType.valueOf(usnHeader);
            for (ServiceType exclusiveServiceType : exclusiveServiceTypes) {
                if (!nst.getServiceType().implementsVersion(exclusiveServiceType)) continue;
                return true;
            }
        }
        catch (InvalidValueException ex) {
            log.finest("Not a named service type header value: " + usnHeader);
        }
        log.fine("Service advertisement not supported, dropping it: " + usnHeader);
        return false;
    }

    @Override
    public ReceivingSync createReceivingSync(StreamRequestMessage message) throws ProtocolCreationException {
        log.fine("Creating protocol for incoming synchronous: " + message);
        if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.GET)) {
            return this.createReceivingRetrieval(message);
        }
        if (this.getUpnpService().getConfiguration().getNamespace().isControlPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.POST)) {
                return this.createReceivingAction(message);
            }
        } else if (this.getUpnpService().getConfiguration().getNamespace().isEventSubscriptionPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.SUBSCRIBE)) {
                return this.createReceivingSubscribe(message);
            }
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNSUBSCRIBE)) {
                return this.createReceivingUnsubscribe(message);
            }
        } else if (this.getUpnpService().getConfiguration().getNamespace().isEventCallbackPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.NOTIFY)) {
                return this.createReceivingEvent(message);
            }
        } else if (message.getUri().getPath().contains("/event/cb")) {
            log.warning("Fixing trailing garbage in event message path: " + message.getUri().getPath());
            String invalid = message.getUri().toString();
            message.setUri(URI.create(invalid.substring(0, invalid.indexOf("/cb") + "/cb".length())));
            if (this.getUpnpService().getConfiguration().getNamespace().isEventCallbackPath(message.getUri()) && ((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.NOTIFY)) {
                return this.createReceivingEvent(message);
            }
        }
        throw new ProtocolCreationException("Protocol for message type not found: " + message);
    }

    @Override
    public SendingNotificationAlive createSendingNotificationAlive(LocalDevice localDevice) {
        return new SendingNotificationAlive(this.getUpnpService(), localDevice);
    }

    @Override
    public SendingNotificationByebye createSendingNotificationByebye(LocalDevice localDevice) {
        return new SendingNotificationByebye(this.getUpnpService(), localDevice);
    }

    @Override
    public SendingSearch createSendingSearch(UpnpHeader searchTarget, int mxSeconds) {
        return new SendingSearch(this.getUpnpService(), searchTarget, mxSeconds);
    }

    @Override
    public SendingAction createSendingAction(ActionInvocation actionInvocation, URL controlURL) {
        return new SendingAction(this.getUpnpService(), actionInvocation, controlURL);
    }

    @Override
    public SendingSubscribe createSendingSubscribe(RemoteGENASubscription subscription) throws ProtocolCreationException {
        try {
            List<NetworkAddress> activeStreamServers = this.getUpnpService().getRouter().getActiveStreamServers(((RemoteDeviceIdentity)((RemoteDevice)((RemoteService)subscription.getService()).getDevice()).getIdentity()).getDiscoveredOnLocalAddress());
            return new SendingSubscribe(this.getUpnpService(), subscription, activeStreamServers);
        }
        catch (RouterException ex) {
            throw new ProtocolCreationException("Failed to obtain local stream servers (for event callback URL creation) from router", ex);
        }
    }

    @Override
    public SendingRenewal createSendingRenewal(RemoteGENASubscription subscription) {
        return new SendingRenewal(this.getUpnpService(), subscription);
    }

    @Override
    public SendingUnsubscribe createSendingUnsubscribe(RemoteGENASubscription subscription) {
        return new SendingUnsubscribe(this.getUpnpService(), subscription);
    }

    @Override
    public SendingEvent createSendingEvent(LocalGENASubscription subscription) {
        return new SendingEvent(this.getUpnpService(), subscription);
    }

    protected ReceivingRetrieval createReceivingRetrieval(StreamRequestMessage message) {
        return new ReceivingRetrieval(this.getUpnpService(), message);
    }

    protected ReceivingAction createReceivingAction(StreamRequestMessage message) {
        return new ReceivingAction(this.getUpnpService(), message);
    }

    protected ReceivingSubscribe createReceivingSubscribe(StreamRequestMessage message) {
        return new ReceivingSubscribe(this.getUpnpService(), message);
    }

    protected ReceivingUnsubscribe createReceivingUnsubscribe(StreamRequestMessage message) {
        return new ReceivingUnsubscribe(this.getUpnpService(), message);
    }

    protected ReceivingEvent createReceivingEvent(StreamRequestMessage message) {
        return new ReceivingEvent(this.getUpnpService(), message);
    }
}

