/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AnswerFile;
import com.vmware.vim25.AnswerFileCreateSpec;
import com.vmware.vim25.AnswerFileStatusResult;
import com.vmware.vim25.AnswerFileUpdateFailed;
import com.vmware.vim25.ApplyProfile;
import com.vmware.vim25.HostApplyProfile;
import com.vmware.vim25.HostConfigFailed;
import com.vmware.vim25.HostConfigSpec;
import com.vmware.vim25.HostProfileManagerConfigTaskList;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ProfileDeferredPolicyOptionParameter;
import com.vmware.vim25.ProfileMetadata;
import com.vmware.vim25.ProfileProfileStructure;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.Profile;
import com.vmware.vim25.mo.ProfileManager;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;

public class HostProfileManager
extends ProfileManager {
    public HostProfileManager(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public Task applyHostConfig_Task(HostSystem host, HostConfigSpec configSpec) throws HostConfigFailed, InvalidState, RuntimeFault, RemoteException {
        return this.applyHostConfig_Task(host, configSpec, null);
    }

    public Task applyHostConfig_Task(HostSystem host, HostConfigSpec configSpec, ProfileDeferredPolicyOptionParameter[] userInputs) throws HostConfigFailed, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().applyHostConfig_Task(this.getMOR(), host.getMOR(), configSpec, userInputs);
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task checkAnswerFileStatus_Task(HostSystem[] hosts) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] hostMors = MorUtil.createMORs(hosts);
        ManagedObjectReference taskMor = this.getVimService().checkAnswerFileStatus_Task(this.getMOR(), hostMors);
        return new Task(this.getServerConnection(), taskMor);
    }

    public ApplyProfile createDefaultProfile(String profileType) throws RuntimeFault, RemoteException {
        return this.createDefaultProfile(profileType, null, null);
    }

    public ApplyProfile createDefaultProfile(String profileType, String profileTypeName, Profile profile) throws RuntimeFault, RemoteException {
        return this.getVimService().createDefaultProfile(this.getMOR(), profileType, profileTypeName, profile == null ? null : profile.getMOR());
    }

    public Task exportAnswerFile_Task(HostSystem host) throws RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().exportAnswerFile_Task(this.getMOR(), host.getMOR());
        return new Task(this.getServerConnection(), taskMor);
    }

    public HostProfileManagerConfigTaskList generateConfigTaskList(HostConfigSpec configSpec, HostSystem host) throws RuntimeFault, RemoteException {
        return this.getVimService().generateConfigTaskList(this.getMOR(), configSpec, host.getMOR());
    }

    public AnswerFileStatusResult[] queryAnswerFileStatus(HostSystem[] hosts) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] hostMors = MorUtil.createMORs(hosts);
        return this.getVimService().queryAnswerFileStatus(this.getMOR(), hostMors);
    }

    public ProfileMetadata[] queryHostProfileMetadata(String[] profileName) throws RuntimeFault, RemoteException {
        return this.getVimService().queryHostProfileMetadata(this.getMOR(), profileName, null);
    }

    public ProfileMetadata[] queryHostProfileMetadata(String[] profileNames, Profile profile) throws RuntimeFault, RemoteException {
        return this.getVimService().queryHostProfileMetadata(this.getMOR(), profileNames, profile == null ? null : profile.getMOR());
    }

    public ProfileProfileStructure queryProfileStructure(Profile profile) throws RuntimeFault, RemoteException {
        return this.getVimService().queryProfileStructure(this.getMOR(), profile.getMOR());
    }

    public AnswerFile retrieveAnswerFile(HostSystem host) throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveAnswerFile(this.getMOR(), host.getMOR());
    }

    public AnswerFile retrieveAnswerFileForProfile(HostSystem host, HostApplyProfile applyProfile) throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveAnswerFileForProfile(this.getMOR(), host == null ? null : host.getMOR(), applyProfile);
    }

    public Task updateAnswerFile_Task(HostSystem host, AnswerFileCreateSpec configSpec) throws AnswerFileUpdateFailed, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().updateAnswerFile_Task(this.getMOR(), host.getMOR(), configSpec);
        return new Task(this.getServerConnection(), taskMor);
    }
}

