/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.commands;

import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.utility.menu.GbtUtility;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public abstract class AbstractCommand<T extends AbstractCommandBuilder<T>>
implements AutoCloseable {
    private static final PeriodFormatter ELAPSED_TIME_FORMATTER = new PeriodFormatterBuilder().appendHours().appendSuffix(" hours, ").appendMinutes().appendSuffix(" mins, ").printZeroAlways().appendSeconds().appendSuffix(".").printZeroAlways().appendMillis3Digit().appendSuffix(" sec.").toFormatter();
    private final DateTime startTime;
    private String totalElapsedTimes;
    protected final T commandArgs;
    protected final AbstractLoggerWriter loggerWriter;
    protected final List<AbstractJSONPOJO> commandResults;
    protected String commandID;

    protected AbstractCommand(T commandArgs) {
        this.commandArgs = commandArgs;
        this.loggerWriter = ((AbstractCommandBuilder)commandArgs).loggerWriter;
        this.startTime = new DateTime();
        this.commandResults = new ArrayList<AbstractJSONPOJO>();
    }

    protected final boolean isOverTime(int timeout) {
        DateTime now = new DateTime();
        DateTime timeLimit = this.startTime.plusMinutes(timeout);
        return now.compareTo((ReadableInstant)timeLimit) > 0;
    }

    protected final String getElapsedTimes() {
        Period period = new Period((ReadableInstant)this.startTime, (ReadableInstant)new DateTime());
        this.totalElapsedTimes = ELAPSED_TIME_FORMATTER.print((ReadablePeriod)period);
        return this.totalElapsedTimes;
    }

    protected final DateTime getStartTime() {
        return this.startTime;
    }

    protected final File getJsonRestorePath() {
        return new File(GbtUtility.getResultsRootPath() + "/" + this.getCommandName() + "/" + this.commandID + ".json");
    }

    public final String getFinalElapsedTimes() {
        if (this.totalElapsedTimes == null) {
            Period period = new Period((ReadableInstant)this.startTime, (ReadableInstant)new DateTime());
            this.totalElapsedTimes = ELAPSED_TIME_FORMATTER.print((ReadablePeriod)period);
        }
        return this.totalElapsedTimes;
    }

    public final String getCommandID() {
        return this.commandID;
    }

    public final List<String> getLogMessages() {
        return this.loggerWriter.getLogMessages();
    }

    public final String getLastLogMessage() {
        if (!this.loggerWriter.getLogMessages().isEmpty()) {
            return this.loggerWriter.getLogMessages().get(this.loggerWriter.getLogMessages().size() - 1);
        }
        return "";
    }

    public final List<AbstractJSONPOJO> getCommandResults() {
        if (this.commandResults.size() == 0) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages(this.getLastLogMessage()));
        }
        return this.commandResults;
    }

    public final <C extends AbstractJSONPOJO> List<C> getCommandResults(Class<C> clazz) {
        ArrayList<C> concreteCommandResults = new ArrayList<C>();
        if (!this.commandResults.isEmpty()) {
            for (AbstractJSONPOJO abstractJSONPOJO : this.commandResults) {
                C temp = abstractJSONPOJO.castConcreteJSON(clazz);
                if (temp == null) continue;
                concreteCommandResults.add(temp);
            }
        }
        return concreteCommandResults;
    }

    public final List<JsonNode> getCommandResultsAsJsonNode() {
        ArrayList<JsonNode> list = new ArrayList<JsonNode>();
        if (!this.commandResults.isEmpty()) {
            for (AbstractJSONPOJO result : this.commandResults) {
                list.add(result.parseJsonNode());
            }
        }
        return list;
    }

    public final <CMD extends AbstractCommand<?>> CMD parserCommand(Class<CMD> clazz) {
        return (CMD)((AbstractCommand)clazz.cast(this));
    }

    public abstract String getCommandName();

    public abstract String getDocumentsName();

    public abstract boolean checkAll();

    public abstract boolean execute();

    public abstract void cancelHook(Object var1);
}

