/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.jsonapi.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public final class JsonByteArraySerializer
extends JsonSerializer<byte[]> {
    private static final String HEXES = "0123456789abcdef";

    public void serialize(byte[] bytes, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        for (byte b : bytes) {
            jgen.writeNumber(JsonByteArraySerializer.byteToHexString(b));
        }
        jgen.writeEndArray();
    }

    private static final String byteToHexString(byte b) {
        return "\"0x" + HEXES.charAt((b & 0xF0) >> 4) + HEXES.charAt(b & 0xF) + "\"";
    }
}

