/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.jsonapi.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public final class JsonJavaByteArraySerializer
extends JsonSerializer<Byte[]> {
    private static final String HEXES = "0123456789abcdef";

    public void serialize(Byte[] bytes, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        for (Byte b : bytes) {
            jgen.writeNumber(JsonJavaByteArraySerializer.byteToHexString(b));
        }
        jgen.writeEndArray();
    }

    private static final String byteToHexString(Byte b) {
        return "\"0x" + HEXES.charAt((b & 0xF0) >> 4) + HEXES.charAt((int)(b & 0xF)) + "\"";
    }
}

