/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.loggers;

import Gbt.core.loggers.GbtLogLevel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggerWriter
implements AutoCloseable {
    public static final String DEFAULT_MDC_KEY = "LogFileName";
    private volatile Boolean isClosed = Boolean.FALSE;
    protected Logger logger;
    protected String MDCKey;
    protected StringBuilder sBuffer;
    protected List<String> logMessages;

    protected AbstractLoggerWriter(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
        this.MDCKey = DEFAULT_MDC_KEY;
        this.sBuffer = new StringBuilder();
        this.logMessages = new ArrayList<String>();
    }

    public abstract void writeLogs(GbtLogLevel var1, String var2, String var3);

    public abstract void writeLogs(GbtLogLevel var1, String var2, String var3, Throwable var4);

    public synchronized AbstractLoggerWriter changeMDCKey(String MDCKey) {
        this.MDCKey = MDCKey;
        return this;
    }

    public AbstractLoggerWriter appendPath(String folderName) {
        if (folderName == null) {
            return this;
        }
        if (this.sBuffer.length() > 0) {
            this.sBuffer.append("/").append(folderName);
        } else {
            this.sBuffer.append(folderName);
        }
        return this;
    }

    public List<String> getLogMessages() {
        return this.logMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Boolean bl = this.isClosed;
        synchronized (bl) {
            if (!this.isClosed.booleanValue()) {
                this.logger = null;
                this.MDCKey = null;
                this.sBuffer.setLength(0);
                this.sBuffer = null;
                this.isClosed = Boolean.TRUE;
            }
        }
    }
}

