/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.receivers;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.AbstractCommandReceiver;
import Gbt.core.receivers.async.RestAsyncInvocationTask;
import Gbt.core.redfish.RedfishBasicUnit;
import Gbt.core.redfish.RedfishErrorResponse;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTRequest;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import Gbt.utility.SMBIOS.SmbiosTypeCollection;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.rest.models.AMIRestSessionData;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.Boundary;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.slf4j.MDC;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class RESTClientReceiver
extends AbstractCommandReceiver {
    private static volatile RESTClientReceiver restClientReceiver;
    private static volatile Logger jerseyLogger;
    private static final int TIMEOUT = 60000;
    private static final ThreadLocal<DateFormat> DATE_FORMAT;

    private RESTClientReceiver() {
        jerseyLogger = Logger.getLogger(RESTClientReceiver.class.getName());
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final RESTClientReceiver getInstance() {
        if (restClientReceiver != null) return restClientReceiver;
        Class<RESTClientReceiver> clazz = RESTClientReceiver.class;
        synchronized (RESTClientReceiver.class) {
            if (restClientReceiver != null) return restClientReceiver;
            restClientReceiver = new RESTClientReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return restClientReceiver;
        }
    }

    @Override
    public String getReceiverName() {
        return "Gbt REST Receiver";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeReceivers() {
        if (restClientReceiver != null) {
            RESTClientReceiver rESTClientReceiver = this;
            synchronized (rESTClientReceiver) {
                if (restClientReceiver != null) {
                    if (SLF4JBridgeHandler.isInstalled()) {
                        SLF4JBridgeHandler.uninstall();
                        jerseyLogger = null;
                    }
                    try {
                        restClientReceiver.close();
                        restClientReceiver = null;
                        return true;
                    }
                    catch (Exception e) {
                        this.taskPool.shutdownNow();
                        this.taskPool = null;
                        this.writeLogs(GbtLogLevel.ERROR, this.getReceiverName(), this.getReceiverName(), "Close " + this.getReceiverName() + " fail.", e);
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public Client createHttpsClient(String username, String password, boolean debug) throws RESTException {
        HostnameVerifier validHostname = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return this.isValidateIP(hostname);
            }

            private boolean isValidateIP(String ipAddress) {
                try {
                    if (ipAddress.indexOf(":") > 0) {
                        ipAddress = ipAddress.split(":")[0];
                    }
                    InetAddress.getByName(ipAddress);
                    return true;
                }
                catch (UnknownHostException une) {
                    return false;
                }
            }
        };
        TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            System.setProperty("https.protocols", "TLSv1.2");
            sslContext.init(null, certs, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            ClientConfig clientConfig = new ClientConfig().register(MultiPartFeature.class).register(JacksonFeature.class).register((Object)HttpAuthenticationFeature.basic((String)username, (String)password)).property("jersey.config.client.suppressHttpComplianceValidation", (Object)true).property("jersey.config.client.connectTimeout", (Object)60000).property("jersey.config.client.readTimeout", (Object)60000);
            if (debug) {
                clientConfig.register((Object)new LoggingFeature(jerseyLogger, Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, null));
            }
            return ClientBuilder.newBuilder().hostnameVerifier(validHostname).sslContext(sslContext).withConfig((Configuration)clientConfig).build();
        }
        catch (GeneralSecurityException gse) {
            throw new RESTException("SSL context initial fail : " + gse.getMessage());
        }
    }

    public Client createHttpsClient(String username, String password, String commandName, String commandID, boolean debug) {
        HostnameVerifier ValidHostname = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return this.isValidateIP(hostname);
            }

            private boolean isValidateIP(String ipAddress) {
                try {
                    if (ipAddress.indexOf(":") > 0) {
                        ipAddress = ipAddress.split(":")[0];
                    }
                    InetAddress.getByName(ipAddress);
                    return true;
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
        };
        TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }
        }};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            System.setProperty("https.protocols", "TLSv1.2");
            sslContext.init(null, certs, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        catch (GeneralSecurityException gse) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Initial SSL context fail.", gse);
            return null;
        }
        ClientConfig clientConfig = new ClientConfig().register(MultiPartFeature.class).register(JacksonFeature.class).register((Object)HttpAuthenticationFeature.basic((String)username, (String)password)).property("jersey.config.client.suppressHttpComplianceValidation", (Object)true).property("jersey.config.client.connectTimeout", (Object)60000).property("jersey.config.client.readTimeout", (Object)60000);
        if (debug) {
            clientConfig.register((Object)new LoggingFeature(jerseyLogger, Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, null));
        }
        return ClientBuilder.newBuilder().hostnameVerifier(ValidHostname).sslContext(sslContext).withConfig((Configuration)clientConfig).build();
    }

    public Client createHttpsClient(String username, String password, String commandName, String commandID, int connectionTimeout, int readTimeout, boolean debug) {
        HostnameVerifier ValidHostname = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return this.isValidateIP(hostname);
            }

            private boolean isValidateIP(String ipAddress) {
                try {
                    if (ipAddress.indexOf(":") > 0) {
                        ipAddress = ipAddress.split(":")[0];
                    }
                    InetAddress.getByName(ipAddress);
                    return true;
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
        };
        TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }
        }};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            System.setProperty("https.protocols", "TLSv1.2");
            sslContext.init(null, certs, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        catch (GeneralSecurityException gse) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Initial SSL context fail.", gse);
            return null;
        }
        ClientConfig clientConfig = new ClientConfig().register(MultiPartFeature.class).register(JacksonFeature.class).register((Object)HttpAuthenticationFeature.basic((String)username, (String)password)).property("jersey.config.client.suppressHttpComplianceValidation", (Object)true).property("jersey.config.client.connectTimeout", (Object)connectionTimeout).property("jersey.config.client.readTimeout", (Object)readTimeout);
        if (debug) {
            clientConfig.register((Object)new LoggingFeature(jerseyLogger, Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, null));
        }
        return ClientBuilder.newBuilder().hostnameVerifier(ValidHostname).sslContext(sslContext).withConfig((Configuration)clientConfig).build();
    }

    public final Response syncInvoke(Client httpClient, RESTRequest request, String commandName, String commandID) throws RESTException {
        WebTarget target = httpClient.target(request.getRestURI());
        if (!request.getQueryPair().isEmpty()) {
            for (String string : request.getQueryPair().keySet()) {
                target = target.queryParam(string, new Object[]{request.getQueryPair().get(string)});
            }
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (!request.getHeaders().isEmpty()) {
            for (String headerKey : request.getHeaders().keySet()) {
                invocationBuilder.header(headerKey, (Object)request.getHeaders().get(headerKey));
            }
        }
        if (!request.getCookies().isEmpty()) {
            for (String cookieKey : request.getCookies().keySet()) {
                invocationBuilder.cookie(request.getCookies().get(cookieKey));
            }
        }
        MDC.put((String)"LogFileName", (String)(commandName + "/" + commandID));
        switch (request.getHttpMethod()) {
            case GET: {
                try {
                    Response response = invocationBuilder.get();
                    return response;
                }
                catch (ProcessingException processingException) {
                    throw new RESTException("Send HTTP GET request fail, connection time out.");
                }
                finally {
                    MDC.remove((String)"LogFileName");
                    MDC.clear();
                }
            }
            case POST: {
                try {
                    Response response = invocationBuilder.post(this.serialize(request));
                    return response;
                }
                catch (ProcessingException processingException) {
                    throw new RESTException("Send HTTP POST request fail, connection time out.");
                }
                finally {
                    MDC.remove((String)"LogFileName");
                    MDC.clear();
                }
            }
            case DELETE: {
                try {
                    if (request.getFormData().isEmpty() && request.getRawJsonData() == null) {
                        Response response = invocationBuilder.delete();
                        return response;
                    }
                    Response response = invocationBuilder.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true).method(request.getHttpMethod().toString(), this.serialize(request));
                    return response;
                }
                catch (ProcessingException processingException) {
                    throw new RESTException("Send HTTP DELETE request fail, connection time out.");
                }
                finally {
                    MDC.remove((String)"LogFileName");
                    MDC.clear();
                }
            }
            case PATCH: {
                try {
                    Response response = invocationBuilder.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true).method(request.getHttpMethod().toString(), this.serialize(request));
                    return response;
                }
                catch (ProcessingException processingException) {
                    throw new RESTException("Send HTTP PATCH request fail, connection time out.");
                }
                finally {
                    MDC.remove((String)"LogFileName");
                    MDC.clear();
                }
            }
            case PUT: {
                try {
                    Response response = invocationBuilder.put(this.serialize(request));
                    return response;
                }
                catch (ProcessingException processingException) {
                    throw new RESTException("Send HTTP PUT request fail, connection time out.");
                }
                finally {
                    MDC.remove((String)"LogFileName");
                    MDC.clear();
                }
            }
        }
        throw new RESTException("Unsupported HTTP method : " + request.getHttpMethod().toString() + " for REST request.");
    }

    public final Future<Response> asyncInvoke(Client httpClient, RESTRequest request, String commandName, String commandID) {
        return this.taskPool.submit(new RestAsyncInvocationTask.Builder().setHttpClient(httpClient).setRequest(request).setLogPath(commandName).build(commandID));
    }

    public final Future<Response> asyncInvoke(RestAsyncInvocationTask.Builder builder, String commandID) {
        return this.taskPool.submit(builder.build(commandID));
    }

    public <T> T deserialize(Response response, Class<T> clazz) throws RESTException {
        switch (response.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                    return null;
                }
                if (clazz == null || clazz == NullJSONData.class) {
                    return null;
                }
                List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
                if (contentTypes != null && !contentTypes.isEmpty() && !contentTypes.get(0).toString().contains("application/json")) {
                    throw new RESTException(response, "Unsupported content type : " + contentTypes);
                }
                if (clazz == AMIRestSessionData.class) {
                    Object body = response.readEntity(clazz);
                    ((AMIRestSessionData)body).getCookies().putAll(response.getCookies());
                    return (T)body;
                }
                try {
                    return (T)response.readEntity(clazz);
                }
                catch (ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + ", cannot parser the incoming messages.", pe);
                }
            }
        }
        List contentTypeL = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypeL != null && !contentTypeL.isEmpty() && !contentTypeL.contains("application/json")) {
            throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity(String.class));
        }
        throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody(JacksonCommonUtil.getUtil().getPrettyPrintString(response.readEntity(Object.class)));
    }

    public <T> T deserialize(Response response, GenericType<T> genericType) throws RESTException {
        switch (response.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                    return null;
                }
                if (genericType == null || genericType.getType() == NullJSONData.class) {
                    return null;
                }
                List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
                if (contentTypes != null && !contentTypes.isEmpty() && !contentTypes.get(0).toString().contains("application/json")) {
                    throw new RESTException(response, "Unsupported content type : " + contentTypes);
                }
                if (genericType.getType() == AMIRestSessionData.class) {
                    Object body = response.readEntity(genericType);
                    ((AMIRestSessionData)body).getCookies().putAll(response.getCookies());
                    return (T)body;
                }
                try {
                    return (T)response.readEntity(genericType);
                }
                catch (ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + ", cannot parser the incoming messages.", pe);
                }
            }
        }
        List contentTypeL = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypeL != null && !contentTypeL.isEmpty() && !contentTypeL.contains("application/json")) {
            throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity((GenericType)new GenericType<String>(){}));
        }
        throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody(JacksonCommonUtil.getUtil().getPrettyPrintString(response.readEntity((GenericType)new GenericType<Object>(){})));
    }

    public final JsonNode deserializeAsJsonNode(Response response) throws RESTException {
        InputStream inputStream = null;
        switch (response.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                    return null;
                }
                if (response.getHeaders().get((Object)"Content-Type") != null && !((List)response.getHeaders().get((Object)"Content-Type")).isEmpty() && !((List)response.getHeaders().get((Object)"Content-Type")).get(0).toString().contains("application/json")) {
                    throw new RESTException(response, "Unsupported content type of Redfish API : " + response.getHeaders().get((Object)"Content-Type"));
                }
                try {
                    inputStream = (InputStream)response.readEntity(InputStream.class);
                    JsonNode jsonNode = JacksonCommonUtil.getUtil().readRootNode(inputStream);
                    return jsonNode;
                }
                catch (IOException | ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + ", cannot parser the incoming messages.", pe);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        inputStream = null;
                    }
                }
            }
            case CLIENT_ERROR: {
                try {
                    inputStream = (InputStream)response.readEntity(InputStream.class);
                    JsonNode pe = JacksonCommonUtil.getUtil().readRootNode(inputStream);
                    return pe;
                }
                catch (IOException | ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + ", cannot parser the incoming error messages.", pe);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        inputStream = null;
                    }
                }
            }
        }
        if (response.getHeaders().get((Object)"Content-Type") != null && !((List)response.getHeaders().get((Object)"Content-Type")).isEmpty() && !((List)response.getHeaders().get((Object)"Content-Type")).get(0).toString().contains("application/json")) {
            throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity((GenericType)new GenericType<String>(){}));
        }
        throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody(JacksonCommonUtil.getUtil().getPrettyPrintString(response.readEntity(RedfishErrorResponse.class)));
    }

    public final RestFullResponseData deserializeAsCommonData(Response response) throws RESTException {
        switch (response.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                    RestFullResponseData redfishRawData = new RestFullResponseData();
                    redfishRawData.setHttpStatus(response.getStatus());
                    redfishRawData.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
                    return redfishRawData;
                }
                if (response.getHeaders().get((Object)"Content-Type") != null && !((List)response.getHeaders().get((Object)"Content-Type")).isEmpty() && !((List)response.getHeaders().get((Object)"Content-Type")).get(0).toString().contains("application/json")) {
                    throw new RESTException(response, "Unsupported content type of Redfish API : " + response.getHeaders().get((Object)"Content-Type"));
                }
                try {
                    RestFullResponseData redfishRawData = new RestFullResponseData();
                    redfishRawData.setHttpStatus(response.getStatus());
                    redfishRawData.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
                    InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
                    if (response.getHeaderString("Content-Encoding") != null && response.getHeaderString("Content-Encoding").equalsIgnoreCase("gzip")) {
                        int iLength;
                        GZIPInputStream ungzip = new GZIPInputStream(inputStream);
                        StringBuilder szBuffer = new StringBuilder();
                        byte[] tByte = new byte[1024];
                        while ((iLength = ungzip.read(tByte, 0, 1024)) >= 0) {
                            szBuffer.append(new String(tByte, 0, iLength));
                        }
                        redfishRawData.setResponseBody(JacksonCommonUtil.getUtil().readRootNode(szBuffer.toString()));
                    } else {
                        redfishRawData.setResponseBody(JacksonCommonUtil.getUtil().readRootNode(inputStream));
                    }
                    return redfishRawData;
                }
                catch (IOException | ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + ", cannot parser the incoming error messages.", pe);
                }
            }
            case CLIENT_ERROR: {
                try {
                    RestFullResponseData redfishRawData = new RestFullResponseData();
                    redfishRawData.setHttpStatus(response.getStatus());
                    redfishRawData.setResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
                    InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
                    redfishRawData.setResponseBody(JacksonCommonUtil.getUtil().readRootNode(inputStream));
                    return redfishRawData;
                }
                catch (IOException | ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + ", cannot parser the incoming error messages.", pe);
                }
            }
        }
        if (response.getHeaders().get((Object)"Content-Type") != null && !((List)response.getHeaders().get((Object)"Content-Type")).isEmpty() && !((List)response.getHeaders().get((Object)"Content-Type")).get(0).toString().contains("application/json")) {
            throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity((GenericType)new GenericType<String>(){}));
        }
        throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody(JacksonCommonUtil.getUtil().getPrettyPrintString(response.readEntity(RedfishErrorResponse.class)));
    }

    public <T extends RedfishBasicUnit> RedfishBasicUnit deserializeAsRedfishUnit(Response response, Class<T> clazz) throws RESTException {
        switch (response.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                    return null;
                }
                if (clazz == null) {
                    return null;
                }
                List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
                if (contentTypes != null && !contentTypes.isEmpty() && !contentTypes.get(0).toString().contains("application/json")) {
                    throw new RESTException(response, "Unsupported content type of Redfish API : " + contentTypes);
                }
                try {
                    return (RedfishBasicUnit)response.readEntity(clazz);
                }
                catch (ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + ", cannot parser the incoming messages.", pe);
                }
            }
            case CLIENT_ERROR: {
                try {
                    return (RedfishBasicUnit)response.readEntity((GenericType)new GenericType<RedfishErrorResponse>(){});
                }
                catch (ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + ", cannot parser the incoming error messages.", pe);
                }
            }
        }
        List contentTypeL = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypeL != null && !contentTypeL.isEmpty() && !contentTypeL.get(0).toString().contains("application/json")) {
            throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity((GenericType)new GenericType<String>(){}));
        }
        throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody(JacksonCommonUtil.getUtil().getPrettyPrintString(response.readEntity((GenericType)new GenericType<RedfishErrorResponse>(){})));
    }

    public <T extends RedfishBasicUnit> RedfishBasicUnit deserializeAsRedfishUnit(Response response, GenericType<T> genericType) throws RESTException {
        switch (response.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                    return null;
                }
                if (genericType == null) {
                    return null;
                }
                List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
                if (contentTypes != null && !contentTypes.isEmpty() && !contentTypes.get(0).toString().contains("application/json")) {
                    throw new RESTException(response, "Unsupported content type of Redfish API : " + contentTypes);
                }
                try {
                    return (RedfishBasicUnit)response.readEntity(genericType);
                }
                catch (ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + ", cannot parser the incoming messages.", pe);
                }
            }
            case CLIENT_ERROR: {
                try {
                    return (RedfishBasicUnit)response.readEntity((GenericType)new GenericType<RedfishErrorResponse>(){});
                }
                catch (ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + ", cannot parser the incoming error messages.", pe);
                }
            }
        }
        List contentTypeL = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypeL != null && !contentTypeL.isEmpty() && !contentTypeL.get(0).toString().contains("application/json")) {
            throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity((GenericType)new GenericType<String>(){}));
        }
        throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody(JacksonCommonUtil.getUtil().getPrettyPrintString(response.readEntity((GenericType)new GenericType<RedfishErrorResponse>(){})));
    }

    public File downloadFile(Response response, File downloadPath) throws RESTException {
        switch (response.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                if (downloadPath.exists()) {
                    downloadPath.delete();
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    inputStream = (InputStream)response.readEntity(InputStream.class);
                    outputStream = new FileOutputStream(downloadPath);
                    IOUtils.write((byte[])IOUtils.toByteArray((InputStream)inputStream), (OutputStream)outputStream);
                    File file = downloadPath;
                    return file;
                }
                catch (ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + " cannot parser the incoming messages.", pe);
                }
                catch (FileNotFoundException fnfe) {
                    throw new RESTException(response, "Download path not exists.", fnfe);
                }
                catch (IOException ioe) {
                    throw new RESTException(response, "Read I/O errors.", ioe);
                }
                finally {
                    try {
                        inputStream.close();
                        outputStream.close();
                    }
                    catch (IOException ioe) {
                        this.writeLogs(GbtLogLevel.ERROR, this.getReceiverName(), response.getLocation().getHost() + "_" + this.getReceiverName(), "Stream close fail.");
                    }
                }
            }
            case CLIENT_ERROR: {
                List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
                if (contentTypes == null) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody("No response entity.");
                }
                if (contentTypes.isEmpty()) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody("No response entity.");
                }
                if (!contentTypes.get(0).toString().contains("application/json")) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity(String.class));
                }
                throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody(JacksonCommonUtil.getUtil().getPrettyPrintString(response.readEntity(Object.class)));
            }
            case SERVER_ERROR: {
                throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity(String.class));
            }
        }
        throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity(String.class));
    }

    public void downloadBase64EncodedFile(Response response, File downloadPath) throws RESTException {
        switch (response.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                if (downloadPath.exists()) {
                    downloadPath.delete();
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    inputStream = (InputStream)response.readEntity(InputStream.class);
                    outputStream = new FileOutputStream(downloadPath);
                    byte[] allData = new Base64().decode(IOUtils.toByteArray((InputStream)inputStream));
                    IOUtils.write((byte[])allData, (OutputStream)outputStream);
                }
                catch (ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + " cannot parser the incoming messages.", pe);
                }
                catch (FileNotFoundException fnfe) {
                    throw new RESTException(response, "Download path not exists.", fnfe);
                }
                catch (IOException ioe) {
                    throw new RESTException(response, "Read I/O errors.", ioe);
                }
                finally {
                    try {
                        inputStream.close();
                        outputStream.close();
                    }
                    catch (IOException ioe) {
                        this.writeLogs(GbtLogLevel.ERROR, this.getReceiverName(), response.getLocation().getHost() + "_" + this.getReceiverName(), "Stream close fail.");
                    }
                }
                return;
            }
            case CLIENT_ERROR: {
                List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
                if (contentTypes == null) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody("No response entity.");
                }
                if (contentTypes.isEmpty()) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody("No response entity.");
                }
                if (!contentTypes.get(0).toString().contains("application/json")) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity(String.class));
                }
                throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody(JacksonCommonUtil.getUtil().getPrettyPrintString(response.readEntity(Object.class)));
            }
            case SERVER_ERROR: {
                throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity(String.class));
            }
        }
        throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity(String.class));
    }

    public List<SmbiosTypeBase> downloadSmbios(Response response, File outputFileName) throws RESTException {
        switch (response.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    inputStream = (InputStream)response.readEntity(InputStream.class);
                    outputStream = new FileOutputStream(outputFileName);
                    byte[] allData = new Base64().decode(IOUtils.toByteArray((InputStream)inputStream));
                    IOUtils.write((byte[])allData, (OutputStream)outputStream);
                    List<SmbiosTypeBase> list = SmbiosTypeCollection.parseFullSMBIOSData(allData);
                    return list;
                }
                catch (ProcessingException pe) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus() + " cannot parser the incoming messages.", pe);
                }
                catch (FileNotFoundException fnfe) {
                    throw new RESTException(response, "Download path not exists.", fnfe);
                }
                catch (IOException ioe) {
                    throw new RESTException(response, "Read I/O errors.", ioe);
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException ioe) {
                        this.writeLogs(GbtLogLevel.ERROR, this.getReceiverName(), response.getLocation().getHost() + "_" + this.getReceiverName(), "Stream close fail.");
                    }
                }
            }
            case CLIENT_ERROR: {
                List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
                if (contentTypes == null) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody("No response entity.");
                }
                if (contentTypes.isEmpty()) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody("No response entity.");
                }
                if (!contentTypes.get(0).toString().contains("application/json")) {
                    throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity(String.class));
                }
                throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody(JacksonCommonUtil.getUtil().getPrettyPrintString(response.readEntity(Object.class)));
            }
            case SERVER_ERROR: {
                throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity(String.class));
            }
        }
        throw new RESTException(response, "HTTP Status : " + response.getStatus()).setUnexpectedBody((String)response.readEntity(String.class));
    }

    public Entity<?> serialize(RESTRequest request) {
        switch (request.getContentType()) {
            case "multipart/form-data": {
                FormDataMultiPart multiPart = new FormDataMultiPart();
                for (String key : request.getFormData().keySet()) {
                    if (request.getFormData().get(key) instanceof File) {
                        File uploadFile = (File)request.getFormData().get(key);
                        multiPart.bodyPart((BodyPart)new FileDataBodyPart(key, uploadFile));
                        continue;
                    }
                    FormDataContentDisposition contentDisp = FormDataContentDisposition.name((String)key).build();
                    multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, this.parameterToString(request.getFormData().get(key))));
                }
                return Entity.entity((Object)multiPart, (MediaType)Boundary.addBoundary((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
            }
            case "application/x-www-form-urlencoded": {
                Form formData = new Form();
                for (String key : request.getFormData().keySet()) {
                    formData.param(key, this.parameterToString(request.getFormData().get(key)));
                }
                return Entity.entity((Object)formData, (String)"application/x-www-form-urlencoded");
            }
        }
        return Entity.entity((Object)request.getRawJsonData(), (String)request.getContentType());
    }

    private String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return DATE_FORMAT.get().format((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(o);
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    static {
        DATE_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            }
        };
    }
}

