/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.receivers.async;

import Gbt.core.receivers.RESTClientReceiver;
import Gbt.core.rest.RESTRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.MDC;

public final class RestAsyncInvocationTask
implements Callable<Response> {
    private final RESTClientReceiver restClientReceiver = RESTClientReceiver.getInstance();
    private final Client httpClient;
    private final RESTRequest request;
    private final String logPath;

    public RestAsyncInvocationTask(Builder builder) {
        this.httpClient = builder.httpClient;
        this.request = builder.request;
        this.logPath = builder.logPathBuilder.toString();
        builder.logPathBuilder.setLength(0);
    }

    @Override
    public Response call() throws CancellationException, ExecutionException {
        WebTarget target = this.httpClient.target(this.request.getRestURI());
        if (!this.request.getQueryPair().isEmpty()) {
            for (String string : this.request.getQueryPair().keySet()) {
                target = target.queryParam(string, new Object[]{this.request.getQueryPair().get(string)});
            }
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (!this.request.getHeaders().isEmpty()) {
            for (String headerKey : this.request.getHeaders().keySet()) {
                invocationBuilder.header(headerKey, (Object)this.request.getHeaders().get(headerKey));
            }
        }
        if (!this.request.getCookies().isEmpty()) {
            for (String cookieKey : this.request.getCookies().keySet()) {
                invocationBuilder.cookie(this.request.getCookies().get(cookieKey));
            }
        }
        MDC.put((String)"LogFileName", (String)this.logPath);
        switch (this.request.getHttpMethod()) {
            case GET: {
                try {
                    Response response = invocationBuilder.get();
                    return response;
                }
                catch (ProcessingException processingException) {
                    throw new ExecutionException("Send HTTP " + this.request.getHttpMethod().toString() + " request fail, connection time out.", processingException);
                }
                finally {
                    MDC.remove((String)"LogFileName");
                    MDC.clear();
                }
            }
            case POST: {
                try {
                    Response response = invocationBuilder.post(this.restClientReceiver.serialize(this.request));
                    return response;
                }
                catch (ProcessingException processingException) {
                    throw new ExecutionException("Send HTTP " + this.request.getHttpMethod().toString() + " request fail, connection time out.", processingException);
                }
                finally {
                    MDC.remove((String)"LogFileName");
                    MDC.clear();
                }
            }
            case DELETE: {
                try {
                    if (this.request.getFormData().isEmpty() && this.request.getRawJsonData() == null) {
                        Response response = invocationBuilder.delete();
                        return response;
                    }
                    Response response = invocationBuilder.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true).method(this.request.getHttpMethod().toString(), this.restClientReceiver.serialize(this.request));
                    return response;
                }
                catch (ProcessingException processingException) {
                    throw new ExecutionException("Send HTTP " + this.request.getHttpMethod().toString() + " request fail, connection time out.", processingException);
                }
                finally {
                    MDC.remove((String)"LogFileName");
                    MDC.clear();
                }
            }
            case PATCH: {
                try {
                    Response response = invocationBuilder.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true).method(this.request.getHttpMethod().toString(), this.restClientReceiver.serialize(this.request));
                    return response;
                }
                catch (ProcessingException processingException) {
                    throw new ExecutionException("Send HTTP " + this.request.getHttpMethod().toString() + " request fail, connection time out.", processingException);
                }
                finally {
                    MDC.remove((String)"LogFileName");
                    MDC.clear();
                }
            }
            case PUT: {
                try {
                    Response response = invocationBuilder.put(this.restClientReceiver.serialize(this.request));
                    return response;
                }
                catch (ProcessingException processingException) {
                    throw new ExecutionException("Send HTTP " + this.request.getHttpMethod().toString() + " request fail, connection time out.", processingException);
                }
                finally {
                    MDC.remove((String)"LogFileName");
                    MDC.clear();
                }
            }
        }
        throw new CancellationException("Unsupported HTTP method : " + this.request.getHttpMethod().toString() + " for REST request.");
    }

    public static final class Builder {
        private Client httpClient;
        private RESTRequest request;
        private StringBuilder logPathBuilder = new StringBuilder();

        public RestAsyncInvocationTask build(String logName) {
            this.logPathBuilder.append(logName);
            return new RestAsyncInvocationTask(this);
        }

        public Builder setHttpClient(Client httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder setRequest(RESTRequest request) {
            this.request = request;
            return this;
        }

        public Builder setLogPath(String logPath) {
            this.logPathBuilder.append(logPath).append("/");
            return this;
        }
    }
}

