/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.protocol;

import Gbt.core.vmedia.protocol.RedirectionHeader;
import Gbt.core.vmedia.protocol.VmRedirectionProtocolException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public final class IUSBHeader
extends RedirectionHeader {
    public static final int IUSB_SIGNATURE_SIZE = 8;
    public static final int IUSB_HEADER_SIZE = 61;
    public static final int HEADER_LEN = 32;
    private static final String IUSB_HEADER = "IUSB    ";
    private static final int IUSB_MAJOR = 1;
    private static final int IUSB_MINOR = 0;
    private byte[] signature;
    private int major;
    private int minor;
    private int headerCheckSum;
    private long dataPacketLen;
    private int serverCaps;
    private int deviceType;
    private int protocol;
    private int direction;
    private int deviceNo;
    private int interfaceNo;
    private int clientData;
    private int instance;
    private long sequenceNo;
    private byte[] key;

    public IUSBHeader(IUSBHeader tempHeader) {
        this.setSignature(new byte[8]);
        System.arraycopy(tempHeader.getSignature(), 0, this.getSignature(), 0, tempHeader.getSignature().length);
        this.setMajor(tempHeader.getMajor());
        this.setMinor(tempHeader.getMinor());
        this.setHeaderLen(tempHeader.getHeaderLen());
        this.setHeaderCheckSum(tempHeader.getHeaderCheckSum());
        this.setDataPktLen(tempHeader.getDataPktLen());
        this.setServerCaps(tempHeader.getServerCaps());
        this.setDeviceType(tempHeader.getDeviceType());
        this.setProtocol(tempHeader.getProtocol());
        this.setDirection(tempHeader.getDirection());
        this.setDeviceNo(tempHeader.getDeviceNo());
        this.setInterfaceNo(tempHeader.getInterfaceNo());
        this.setClientData(tempHeader.getClientData());
        this.setInstance(tempHeader.getInstance());
        this.setSeqNo(tempHeader.getSeqNo());
        this.setKey(tempHeader.getKey());
    }

    public IUSBHeader() {
        this.headerLen = 32;
        this.signature = new byte[8];
        this.key = new byte[4];
    }

    public IUSBHeader(int dataLen) {
        this.signature = IUSB_HEADER.getBytes();
        this.headerLen = 32;
        this.major = 1;
        this.minor = 0;
        this.sequenceNo = 0L;
        this.direction = 128;
        this.dataPacketLen = dataLen;
        this.deviceType = 5;
        this.deviceNo = 0;
        this.interfaceNo = 0;
        this.protocol = 1;
        this.key = new byte[4];
    }

    public IUSBHeader(ByteBuffer request) {
        byte[] testByte = new byte[8];
        this.setSignature(new byte[8]);
        this.key = new byte[4];
        request.get(testByte, 0, 8);
        System.arraycopy(testByte, 0, this.signature, 0, 8);
        this.major = request.get() & 0xFF;
        this.minor = request.get() & 0xFF;
        this.headerLen = request.get() & 0xFF;
        this.headerCheckSum = request.get() & 0xFF;
        this.dataPacketLen = (long)request.getInt() & 0xFFFFFFFFFFFFFFFFL;
        this.serverCaps = request.get() & 0xFF;
        this.deviceType = request.get() & 0xFF;
        this.protocol = request.get() & 0xFF;
        this.direction = request.get() & 0xFF;
        this.deviceNo = request.get() & 0xFF;
        this.interfaceNo = request.get() & 0xFF;
        this.clientData = request.get() & 0xFF;
        this.instance = request.get() & 0xFF;
        this.sequenceNo = (long)request.getInt() & 0xFFFFFFFFFFFFFFFFL;
        request.get(this.key);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getHeaderLen() {
        return this.headerLen;
    }

    public void setHeaderLen(int headerLen) {
        this.headerLen = headerLen;
    }

    public int getHeaderCheckSum() {
        return this.headerCheckSum;
    }

    public void setHeaderCheckSum(int headerCheckSum) {
        this.headerCheckSum = headerCheckSum;
    }

    public long getDataPktLen() {
        return this.dataPacketLen;
    }

    public void setDataPktLen(long l) {
        this.dataPacketLen = l;
    }

    public int getServerCaps() {
        return this.serverCaps;
    }

    public void setServerCaps(int serverCaps) {
        this.serverCaps = serverCaps;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getDeviceNo() {
        return this.deviceNo;
    }

    public void setDeviceNo(int deviceNo) {
        this.deviceNo = deviceNo;
    }

    public int getInterfaceNo() {
        return this.interfaceNo;
    }

    public void setInterfaceNo(int interfaceNo) {
        this.interfaceNo = interfaceNo;
    }

    public int getClientData() {
        return this.clientData;
    }

    public void setClientData(int clientData) {
        this.clientData = clientData;
    }

    public int getInstance() {
        return this.instance;
    }

    public void setInstance(int instance) {
        this.instance = instance;
    }

    public long getSeqNo() {
        return this.sequenceNo;
    }

    public void setSeqNo(long l) {
        this.sequenceNo = l;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    @Override
    public void read(ByteBuffer rawBuffer) throws VmRedirectionProtocolException, BufferUnderflowException {
        rawBuffer.get(this.signature);
        String signatureString = new String(this.signature);
        if (!signatureString.equals(IUSB_HEADER)) {
            throw new VmRedirectionProtocolException("7_1_IUSBH");
        }
        this.major = rawBuffer.get() & 0xFF;
        this.minor = rawBuffer.get() & 0xFF;
        this.headerLen = rawBuffer.get() & 0xFF;
        this.headerCheckSum = rawBuffer.get() & 0xFF;
        this.dataPacketLen = (long)rawBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        this.serverCaps = rawBuffer.get() & 0xFF;
        this.deviceType = rawBuffer.get() & 0xFF;
        this.protocol = rawBuffer.get() & 0xFF;
        this.direction = rawBuffer.get() & 0xFF;
        this.deviceNo = rawBuffer.get() & 0xFF;
        this.interfaceNo = rawBuffer.get() & 0xFF;
        this.clientData = rawBuffer.get() & 0xFF;
        this.instance = rawBuffer.get() & 0xFF;
        this.sequenceNo = (long)rawBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        rawBuffer.get(this.key);
    }

    @Override
    public void write(ByteBuffer rawBuffer) {
        rawBuffer.put(this.signature);
        rawBuffer.put((byte)(this.major & 0xFF));
        rawBuffer.put((byte)(this.minor & 0xFF));
        rawBuffer.put((byte)(this.headerLen & 0xFF));
        rawBuffer.put((byte)(this.headerCheckSum & 0xFF));
        rawBuffer.putInt((int)(this.dataPacketLen & 0xFFFFFFFFFFFFFFFFL));
        rawBuffer.put((byte)(this.serverCaps & 0xFF));
        rawBuffer.put((byte)(this.deviceType & 0xFF));
        rawBuffer.put((byte)(this.protocol & 0xFF));
        rawBuffer.put((byte)(this.direction & 0xFF));
        rawBuffer.put((byte)(this.deviceNo & 0xFF));
        rawBuffer.put((byte)(this.interfaceNo & 0xFF));
        rawBuffer.put((byte)(this.clientData & 0xFF));
        rawBuffer.put((byte)(this.instance & 0xFF));
        rawBuffer.putInt((int)(this.sequenceNo & 0xFFFFFFFFFFFFFFFFL));
        rawBuffer.put(this.key);
        int temp = 0;
        for (int i = 0; i < rawBuffer.limit(); ++i) {
            temp = temp + (rawBuffer.get(i) & 0xFF) & 0xFF;
        }
        rawBuffer.put(11, -((byte)(temp & 0xFF)));
    }
}

