/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.CPLD;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.CPLD.CPLDJsonData;
import Gbt.utility.CPLD.CPLDListJsonData;
import Gbt.utility.CPLD.ECVersionJsonData;
import Gbt.utility.CPLD.GetCPLDCommand;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Hex;

public enum CpldIpmiOptions implements GbtIPMIOptions<GetCPLDCommand.Builder>
{
    OEM(0, "OEM", 17);

    private static final String OEM_ITEM = "OEM";
    private static final byte NetFn = 46;
    private final int optionCode;
    private final String item;
    private final byte cmd;
    private static final int START_POINT = 3;
    private static final int VERSION_BYTE_NUM = 6;

    private CpldIpmiOptions(int optionCode, String item, byte cmd) {
        this.optionCode = optionCode;
        this.item = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 46;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(GetCPLDCommand.Builder commandArgs) {
        switch (this) {
            case OEM: {
                return new byte[]{10, 60, 0, 17};
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        CPLDListJsonData cpldListJsonData = new CPLDListJsonData();
        ArrayList<CPLDJsonData> cpldList = new ArrayList<CPLDJsonData>();
        boolean ecVersionExist = false;
        for (int i = 3; i < gbtResponseData.getAllResponseData().length; i += 6) {
            CPLDJsonData data = new CPLDJsonData();
            String userCode = "";
            int userCodeStart = i;
            for (int j = 0; j < 6; ++j) {
                if (userCodeStart + j >= gbtResponseData.getAllResponseData().length) {
                    if (j != 2) break;
                    ecVersionExist = true;
                    break;
                }
                byte respByte = gbtResponseData.getResponseData(userCodeStart + j);
                userCode = userCode + "0x" + Hex.encodeHexString((byte[])new byte[]{respByte}) + " ";
                if (j != userCodeStart) continue;
                data.setCpldVerString("0x" + Hex.encodeHexString((byte[])new byte[]{respByte}));
                data.setCpldVerByte(respByte);
            }
            if (ecVersionExist) {
                cpldListJsonData.setEcVersionData(new ECVersionJsonData().setEcVersion(userCode.trim()));
                continue;
            }
            data.setUserCode(userCode.trim());
            cpldList.add(data);
        }
        cpldListJsonData.setCpldVersionList(cpldList);
        return cpldListJsonData;
    }
}

