/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.IKVM;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.engines.records.LocalCmdRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.core.rest.RESTServices;
import Gbt.core.vmedia.data.KvmSessionToken;
import Gbt.utility.API.GbtUtilityAPI2;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.IKVM.JNLPBase;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.rest.models.AMIRestSessionData;
import Gbt.utility.rest.options.NoServiceOptions;
import Gbt.utility.rest.services.KVMService;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public final class LaunchiKVMCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "ikvm";
    private GbtIPMICommandReceiver ipmiReceiver;
    private GbtLocalCommandReceiver localReceiver;

    protected LaunchiKVMCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI command receiver is null.");
            return false;
        }
        if (this.localReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Local command receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, this.getCommandName(), this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start run iKVM.");
                CommandTaskRecords report = GbtUtilityAPI2.commonCommand(GbtCommandBuilders.mcinfo(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword));
                AbstractJSONPOJO data = report.getResultData().get(0);
                if (data instanceof NullJSONData) {
                    NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    this.commandResults.add(temp);
                    return false;
                }
                BMCInfoJSONData bmcInfo = data.castConcreteJSON(BMCInfoJSONData.class);
                String jnlpContent = JNLPBase.getVertivJNLPContent(((Builder)this.commandArgs).bmcIP, bmcInfo.isAST2500(), ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword);
                File filePath = JNLPBase.getJNLPFileName(((Builder)this.commandArgs).bmcIP);
                try {
                    FileUtils.writeStringToFile((File)filePath, (String)jnlpContent);
                }
                catch (IOException ioe) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] write file fail.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Cannot write the JNLP file."));
                    return false;
                }
                if (!((Builder)this.commandArgs).setExecute) {
                    this.commandResults.add(new NullJSONData().setError(false).setMessages("Only get jnlp path : " + filePath.getAbsolutePath()));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Only get jnlp path : " + filePath.getAbsolutePath());
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    return true;
                }
                if (!filePath.exists()) break;
                LocalCmdRecords iKVMRecords = CommonFunction.isWindows() ? this.localReceiver.executeLocalCommand(filePath.getAbsolutePath(), GbtLogLevel.INFO, this.getCommandName(), this.commandID) : this.localReceiver.executeLocalCommand("javaws " + filePath.getAbsolutePath(), GbtLogLevel.INFO, this.getCommandName(), this.commandID);
                if (iKVMRecords.getStates().isFail()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Activate the iKVM fail.");
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + iKVMRecords.getErrors());
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("ikvm execute fail."));
                    filePath.delete();
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                    filePath.delete();
                    break;
                }
                catch (InterruptedException e) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupted the iKVM.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("ikvm execute fail."));
                    filePath.delete();
                    return false;
                }
            }
            case AMI: {
                if (((Builder)this.commandArgs).setExecute) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Run JViewer.");
                    if (!((Builder)this.commandArgs).jviewerMode) {
                        File jnlpFile = null;
                        jnlpFile = this.createAMIJnlpFile();
                        if (jnlpFile != null) {
                            if (!jnlpFile.exists()) break;
                            LocalCmdRecords iKVMRecords = CommonFunction.isWindows() ? this.localReceiver.executeLocalCommand(jnlpFile.getAbsolutePath(), GbtLogLevel.INFO, this.getCommandName(), this.commandID) : this.localReceiver.executeLocalCommand("javaws " + jnlpFile.getAbsolutePath(), GbtLogLevel.INFO, this.getCommandName(), this.commandID);
                            if (iKVMRecords.getStates().isFail()) {
                                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Activate the iKVM fail.");
                                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + iKVMRecords.getErrors());
                                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                                this.commandResults.add(new NullJSONData().setError(true).setMessages("ikvm execute fail."));
                                jnlpFile.delete();
                                return false;
                            }
                            try {
                                Thread.sleep(1000L);
                                jnlpFile.delete();
                                break;
                            }
                            catch (InterruptedException e) {
                                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupted the iKVM.");
                                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                                this.commandResults.add(new NullJSONData().setError(true).setMessages("ikvm execute fail."));
                                jnlpFile.delete();
                                return false;
                            }
                        }
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get kvm token fail.");
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        return false;
                    }
                    if (!this.executeJViewerLocally()) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execute jviewer fail.");
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        return false;
                    }
                    return true;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Skip run JViewer.");
                this.commandResults.add(new NullJSONData().setError(false).setMessages("Skip run JViewer."));
                break;
            }
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                return false;
            }
        }
        this.commandResults.add(new NullJSONData().setError(false).setMessages("ikvm execute success."));
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private File createAMIJnlpFile() {
        KvmSessionToken kvmToken = null;
        AMIRestSessionData session = null;
        KVMService restServices = new KVMService(this.loggerWriter);
        restServices.setLogDirPath(this.getCommandName());
        if (!restServices.openSession(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, ((Builder)this.commandArgs).debug)) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Open rest session fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Open rest session fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return null;
        }
        if (!((RESTServices)restServices).execute(((Builder)this.commandArgs).bmcIP, NoServiceOptions.NoOptions)) {
            restServices.closeSession(((Builder)this.commandArgs).bmcIP);
            this.commandResults.addAll(restServices.getJsonResults());
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return null;
        }
        restServices.closeSession(((Builder)this.commandArgs).bmcIP);
        this.commandResults.addAll(restServices.getJsonResults());
        for (AbstractJSONPOJO result : restServices.getJsonResults()) {
            if (result instanceof KvmSessionToken) {
                kvmToken = result.castConcreteJSON(KvmSessionToken.class);
                continue;
            }
            if (!(result instanceof AMIRestSessionData)) continue;
            session = result.castConcreteJSON(AMIRestSessionData.class);
        }
        if (kvmToken == null || session == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] KVM token or session data is not valid!");
            return null;
        }
        String jnlpContent = JNLPBase.getAMIJNLPContent(((Builder)this.commandArgs).bmcIP, kvmToken.getKvmToken(), kvmToken.getKvmSessionCookie(), session.getCSRFToken());
        File filePath = JNLPBase.getJNLPFileName(((Builder)this.commandArgs).bmcIP);
        try {
            FileUtils.writeStringToFile((File)filePath, (String)jnlpContent);
        }
        catch (IOException ioe) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] write file fail.");
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Cannot write the JNLP file."));
            return null;
        }
        return filePath;
    }

    private boolean executeJViewerLocally() {
        LocalCmdRecords jviewerRecords = this.localReceiver.executeLocalCommand("java -jar ./tools/AMI_JViewer/JViewer.jar -apptype StandAlone -hostname " + ((Builder)this.commandArgs).bmcIP + " -u " + ((Builder)this.commandArgs).bmcUsername + " -p " + ((Builder)this.commandArgs).bmcPassword + " -webport 443 -launch jviewer");
        if (jviewerRecords.getStates().isFail()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Activate JViewer fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + jviewerRecords.getErrors());
            this.commandResults.add(new NullJSONData().setError(true).setMessages("JViewer execute fail."));
            return false;
        }
        return true;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private boolean setExecute = true;
        private boolean debug = false;
        private boolean jviewerMode = false;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            this.commandLineParser(this.args);
            return true;
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setSetExecute(boolean setExecute) {
            this.setExecute = setExecute;
            return this.getThis();
        }

        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this.getThis();
        }

        public Builder setJviewerMode(boolean jviewerMode) {
            this.jviewerMode = jviewerMode;
            return this.getThis();
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public LaunchiKVMCommand build() {
            return new LaunchiKVMCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.loggerWriter.close();
        }

        private void commandLineParser(String[] args) {
            block8: for (int i = 0; i < args.length; ++i) {
                switch (args[i]) {
                    case "debug": {
                        this.debug = true;
                        continue block8;
                    }
                    case "jviewer": {
                        this.jviewerMode = true;
                    }
                }
            }
        }
    }
}

