/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.LoadDefault;

import Gbt.core.ipmi.GbtIPMIConnector;
import Gbt.core.ipmi.GbtIpmiCommandCoder;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.utility.Common.GbtCommonConverters;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.session.SetSessionPrivilegeLevel;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class TransferLoadDefaultConifgFilethroughIPMI {
    private static final int MAXIMUM_RETRY_COUNT = 2;
    private static final byte[] GBT_IANA = new byte[]{10, 60, 0};
    private String message = "";
    private boolean critical = false;
    private ConnectionHandle handle;
    private List<CipherSuite> css;

    public boolean isCritical() {
        return this.critical;
    }

    public String getMessage() {
        return this.message;
    }

    public void close() {
        this.message = null;
        if (this.handle != null) {
            this.handle = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String IPAddress, String filepath, byte option, String username, String password) {
        long SEPERATE_PORTION_SIZE = 100L;
        byte netFn = 46;
        byte cmd = 80;
        byte[] fileSizeHex = new byte[4];
        long fileSize = 0L;
        FileInputStream fis = null;
        if (option != 1 && option != 2) {
            this.message = "Sending option is undefine: " + option;
            System.out.println("[TransferLoadDefaultConifgFilethroughIPMI] " + this.message);
            this.critical = true;
            return;
        }
        File file = new File(filepath);
        if (!file.isFile()) {
            this.message = "No such file.";
            this.critical = true;
            return;
        }
        fileSize = file.length();
        this.message = (double)fileSize / 1000.0 + " KB.";
        System.out.println("[TransferLoadDefaultConifgFilethroughIPMI] " + this.message);
        fileSizeHex = GbtCommonConverters.LongToByteArray(fileSize);
        try {
            long offset;
            fis = new FileInputStream(file);
            this.setSession(IPAddress, username, password);
            for (offset = 0L; offset < fileSize; offset += 100L) {
                long restSize = fileSize - offset;
                byte fragSize = 0;
                fragSize = restSize > 100L ? (byte)100 : (byte)((byte)(fileSize - offset & 0xFFL));
                byte[] filePortion = new byte[fragSize];
                fis.read(filePortion);
                ArrayList<byte[]> rawdataList = new ArrayList<byte[]>();
                rawdataList.add(GBT_IANA);
                rawdataList.add(new byte[]{-128, option});
                rawdataList.add(fileSizeHex);
                rawdataList.add(new byte[]{fragSize});
                rawdataList.add(GbtCommonConverters.LongToByteArray(offset));
                rawdataList.add(filePortion);
                byte[] RequestData = GbtCommonConverters.ArrayListToRawdata(rawdataList);
                boolean success = false;
                int retry = 0;
                do {
                    try {
                        GbtIpmiCommandCoder keyinipmiCommand = new GbtIpmiCommandCoder(this.css.get(3), netFn, cmd, RequestData);
                        GbtIpmiCommandResponseData kid = (GbtIpmiCommandResponseData)GbtIPMIConnector.getConnector().sendMessage(this.handle, keyinipmiCommand);
                        kid.isHasResponseData();
                        success = true;
                    }
                    catch (Exception e) {
                        if (retry > 2) {
                            throw e;
                        }
                        System.out.println("[TransferLoadDefaultConifgFilethroughIPMI] (" + IPAddress + ") send " + filepath + " portion " + offset + "failed. retry " + retry);
                        ++retry;
                        success = false;
                    }
                } while (!success && retry <= 2);
            }
            if (offset >= fileSize) {
                this.message = "Transfer complete.";
            }
        }
        catch (Exception e) {
            this.message = "(" + IPAddress + ") exception: " + e.getMessage();
            this.critical = true;
        }
        finally {
            if (this.handle != null) {
                try {
                    GbtIPMIConnector.getConnector().closeSession(this.handle);
                    GbtIPMIConnector.getConnector().closeConnection(this.handle);
                }
                catch (Exception e) {
                    this.critical = true;
                    this.message = "Close session exception: " + e.getMessage();
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e1) {
                    this.critical = true;
                    this.message = "Close input stream exception: " + e1.getMessage();
                    System.out.println("[TransferLoadDefaultConifgFilethroughIPMI] " + this.message);
                }
            }
        }
    }

    private void setSession(String IPAddress, String username, String password) throws Exception {
        this.handle = GbtIPMIConnector.getConnector().createConnection(InetAddress.getByName(IPAddress));
        this.css = GbtIPMIConnector.getConnector().getAvailableCipherSuites(this.handle);
        GbtIPMIConnector.getConnector().getChannelAuthenticationCapabilities(this.handle, this.css, PrivilegeLevel.Administrator);
        GbtIPMIConnector.getConnector().openSession(this.handle, username, password, null);
        GbtIPMIConnector.getConnector().sendMessage(this.handle, new SetSessionPrivilegeLevel(IpmiVersion.V20, this.handle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator));
    }
}

