/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.NTP;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.API.GbtUtilityAPI2;
import Gbt.utility.NTP.NtpCommandIpmiOptions;
import Gbt.utility.NTP.NtpJsonData;
import Gbt.utility.NTP.NtpOperationMode;
import Gbt.utility.NTP.NtpServerHostData;
import Gbt.utility.NTP.NtpTscMode;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class NtpCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "ntp";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private static final int NTP_WAIT_TIME = 2000;

    protected NtpCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        return this.ipmiReceiver != null;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        CommandTaskRecords report = GbtUtilityAPI2.commonCommand(GbtCommandBuilders.mcinfo(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword));
        AbstractJSONPOJO data = report.getResultData().get(0);
        if (data instanceof NullJSONData) {
            NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        BMCInfoJSONData bmcInfo = data.castConcreteJSON(BMCInfoJSONData.class);
        switch (bmcInfo.getBmcVendor()) {
            case VERTIV: {
                break;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + (Object)((Object)bmcInfo.getBmcVendor()) + " vendor.");
                return false;
            }
        }
        if (!bmcInfo.isCMC() && !bmcInfo.isAST2500()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcInfo.getBmcGen().toString() + " BMC.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        if (((Builder)this.commandArgs).action) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start set NTP data.");
            AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, NtpCommandIpmiOptions.SET_MODE, this.commandArgs, COMMAND_NAME, this.commandID);
            if (this.isIPMISendMessagesFail(resp, handle)) {
                return false;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupted the execution.");
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            if (!((Builder)this.commandArgs).ntpServerDataList.isEmpty()) {
                ((Builder)this.commandArgs).serverIdCount = 0;
                while (((Builder)this.commandArgs).serverIdCount < ((Builder)this.commandArgs).ntpServerDataList.size()) {
                    resp = this.ipmiReceiver.sendIPMIRawCommand(handle, NtpCommandIpmiOptions.SET_SERVER_IP, this.commandArgs, COMMAND_NAME, this.commandID);
                    if (this.isIPMISendMessagesFail(resp, handle)) {
                        return false;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupted the execution.");
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                    ++((Builder)this.commandArgs).serverIdCount;
                }
            }
            if (((Builder)this.commandArgs).ntpUploadData.getFrequency() != 0) {
                resp = this.ipmiReceiver.sendIPMIRawCommand(handle, NtpCommandIpmiOptions.SET_UPDATE_FREQUENCY, this.commandArgs, COMMAND_NAME, this.commandID);
                if (this.isIPMISendMessagesFail(resp, handle)) {
                    return false;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupted the execution.");
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
            }
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return true;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start get NTP data.");
        ArrayList<NtpServerHostData> hostData = new ArrayList<NtpServerHostData>();
        NtpJsonData finalRespData = new NtpJsonData().setNtpServerHostData(hostData);
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, NtpCommandIpmiOptions.GET_MODE, this.commandArgs, COMMAND_NAME, this.commandID);
        if (this.isIPMISendMessagesFail(resp, handle)) {
            return false;
        }
        finalRespData.setOperationMode(resp.castConcreteJSON(NtpJsonData.class).getOperationMode());
        finalRespData.setTimeSynchronizationMethod(resp.castConcreteJSON(NtpJsonData.class).getTimeSynchronizationMethod());
        ((Builder)this.commandArgs).serverIdCount = 0;
        while (((Builder)this.commandArgs).serverIdCount < 3) {
            resp = this.ipmiReceiver.sendIPMIRawCommand(handle, NtpCommandIpmiOptions.GET_SERVER_IP, this.commandArgs, COMMAND_NAME, this.commandID);
            if (!this.isIPMISendMessagesFail(resp, handle)) {
                hostData.add(resp.castConcreteJSON(NtpServerHostData.class).setId(new BigInteger(String.valueOf(((Builder)this.commandArgs).serverIdCount + 1))));
            }
            ++((Builder)this.commandArgs).serverIdCount;
        }
        resp = this.ipmiReceiver.sendIPMIRawCommand(handle, NtpCommandIpmiOptions.GET_UPDATE_FREQUENCY, this.commandArgs, COMMAND_NAME, this.commandID);
        if (this.isIPMISendMessagesFail(resp, handle)) {
            return false;
        }
        finalRespData.setFrequency(resp.castConcreteJSON(NtpJsonData.class).getFrequency());
        this.commandResults.add(finalRespData);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, finalRespData.toString());
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private boolean isIPMISendMessagesFail(AbstractJSONPOJO resp, ConnectionHandle handle) {
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            if (temp.isError()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return true;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
        }
        return false;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private static final String CMD_ITEM_SERVER1 = "server1=";
        private static final String CMD_ITEM_SERVER2 = "server2=";
        private static final String CMD_ITEM_SERVER3 = "server3=";
        private static final String CMD_ITEM_FREQ = "freq=";
        private static final String CMD_ITEM_TSM = "tsm=";
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private boolean action = false;
        private List<NtpServerHostData> ntpServerDataList;
        protected NtpJsonData ntpUploadData;
        protected int serverIdCount = 0;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                this.loggerWriter.appendPath(NtpCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, "0.0.0.0_ntp", "BMC IP address is null.");
                return false;
            }
            if (this.args != null) {
                if (this.args.length < 1) {
                    this.loggerWriter.appendPath(NtpCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + NtpCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid arguments length.");
                    return false;
                }
                switch (this.args[0].toLowerCase()) {
                    case "set": {
                        this.action = true;
                        break;
                    }
                    case "get": {
                        this.action = false;
                        break;
                    }
                    default: {
                        this.loggerWriter.appendPath(NtpCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + NtpCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid action of " + NtpCommand.COMMAND_NAME + " command.");
                        return false;
                    }
                }
                if (this.action) {
                    if (this.args.length < 2) {
                        this.loggerWriter.appendPath(NtpCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + NtpCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid arguments length.");
                        return false;
                    }
                    this.ntpServerDataList = new ArrayList<NtpServerHostData>();
                    this.ntpUploadData = new NtpJsonData().setNtpServerHostData(this.ntpServerDataList);
                    this.ntpUploadData.setOperationMode(NtpOperationMode.parse(this.args[1]));
                    switch (this.ntpUploadData.getOperationMode()) {
                        case Disable: {
                            break;
                        }
                        case DaemonMode: {
                            for (String arg : this.args) {
                                if (arg.contains(CMD_ITEM_SERVER1)) {
                                    this.ntpServerDataList.add(new NtpServerHostData().setId(new BigInteger("1")).setServerHost(arg.substring(arg.lastIndexOf(CMD_ITEM_SERVER1) + CMD_ITEM_SERVER1.length())));
                                }
                                if (arg.contains(CMD_ITEM_SERVER2)) {
                                    this.ntpServerDataList.add(new NtpServerHostData().setId(new BigInteger("2")).setServerHost(arg.substring(arg.lastIndexOf(CMD_ITEM_SERVER2) + CMD_ITEM_SERVER2.length())));
                                }
                                if (!arg.contains(CMD_ITEM_SERVER3)) continue;
                                this.ntpServerDataList.add(new NtpServerHostData().setId(new BigInteger("3")).setServerHost(arg.substring(arg.lastIndexOf(CMD_ITEM_SERVER3) + CMD_ITEM_SERVER3.length())));
                            }
                            break;
                        }
                        case RequestedMode: {
                            for (String arg : this.args) {
                                if (arg.contains(CMD_ITEM_SERVER1)) {
                                    this.ntpServerDataList.add(new NtpServerHostData().setId(new BigInteger("1")).setServerHost(arg.substring(arg.lastIndexOf(CMD_ITEM_SERVER1) + CMD_ITEM_SERVER1.length())));
                                }
                                if (arg.contains(CMD_ITEM_SERVER2)) {
                                    this.ntpServerDataList.add(new NtpServerHostData().setId(new BigInteger("2")).setServerHost(arg.substring(arg.lastIndexOf(CMD_ITEM_SERVER2) + CMD_ITEM_SERVER2.length())));
                                }
                                if (arg.contains(CMD_ITEM_SERVER3)) {
                                    this.ntpServerDataList.add(new NtpServerHostData().setId(new BigInteger("3")).setServerHost(arg.substring(arg.lastIndexOf(CMD_ITEM_SERVER3) + CMD_ITEM_SERVER3.length())));
                                }
                                if (arg.contains(CMD_ITEM_FREQ)) {
                                    try {
                                        this.ntpUploadData.setFrequency(Integer.parseInt(arg.substring(arg.lastIndexOf(CMD_ITEM_FREQ) + CMD_ITEM_FREQ.length())));
                                    }
                                    catch (NumberFormatException nfe) {
                                        this.loggerWriter.appendPath(NtpCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + NtpCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid number format of request update frequency.");
                                        return false;
                                    }
                                }
                                if (!arg.contains(CMD_ITEM_TSM)) continue;
                                this.ntpUploadData.setTimeSynchronizationMethod(NtpTscMode.parse(arg.substring(arg.lastIndexOf(CMD_ITEM_TSM) + CMD_ITEM_TSM.length())));
                            }
                            break;
                        }
                        default: {
                            this.loggerWriter.appendPath(NtpCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + NtpCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid operation mode of " + NtpCommand.COMMAND_NAME + " command.");
                            return false;
                        }
                    }
                }
            }
            if (this.action) {
                if (this.ntpUploadData == null) {
                    this.loggerWriter.appendPath(NtpCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + NtpCommand.COMMAND_NAME, "[" + this.bmcIP + "] NTP upload data is empty.");
                    return false;
                }
                switch (this.ntpUploadData.getOperationMode()) {
                    case Disable: 
                    case DaemonMode: 
                    case RequestedMode: {
                        break;
                    }
                    default: {
                        this.loggerWriter.appendPath(NtpCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + NtpCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid operation mode of " + NtpCommand.COMMAND_NAME + " command.");
                        return false;
                    }
                }
                return true;
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public NtpCommand build() {
            return new NtpCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setAction(boolean action) {
            this.action = action;
            return this.getThis();
        }

        public Builder setNtpUploadData(NtpJsonData ntpUploadData) {
            this.ntpUploadData = ntpUploadData;
            this.ntpServerDataList = ntpUploadData.getNtpServerHostData();
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.bmcUsername = null;
            this.bmcPassword = null;
            if (this.ntpServerDataList != null) {
                this.ntpServerDataList.clear();
                this.ntpServerDataList = null;
            }
            this.ntpUploadData = null;
            this.action = false;
            this.serverIdCount = 0;
            this.loggerWriter.close();
        }
    }
}

