/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import com.fasterxml.jackson.annotation.JsonValue;

public enum PhysicalMemoryArrayErrs {
    Other(1, "Other"),
    Unknown(2, "Unknown"),
    None(3, "None"),
    Parity(4, "Parity"),
    MultiBitECC(5, "Multi-bit ECC"),
    NonVolatileRAM(6, "Non-volatile RAM"),
    CRC(7, "CRC");

    private static final byte CODE_1 = 1;
    private static final byte CODE_2 = 2;
    private static final byte CODE_3 = 3;
    private static final byte CODE_4 = 4;
    private static final byte CODE_5 = 5;
    private static final byte CODE_6 = 6;
    private static final byte CODE_7 = 7;
    private static final String ITEM_1 = "Other";
    private static final String ITEM_2 = "Unknown";
    private static final String ITEM_3 = "None";
    private static final String ITEM_4 = "Parity";
    private static final String ITEM_5 = "Multi-bit ECC";
    private static final String ITEM_6 = "Non-volatile RAM";
    private static final String ITEM_7 = "CRC";
    private final byte code;
    private final String item;

    private PhysicalMemoryArrayErrs(byte code, String item) {
        this.code = code;
        this.item = item;
    }

    public byte getCode() {
        return this.code;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final PhysicalMemoryArrayErrs parseErrCorrection(byte errCorr) {
        switch (errCorr) {
            case 1: {
                return Other;
            }
            case 2: {
                return Unknown;
            }
            case 3: {
                return None;
            }
            case 4: {
                return Parity;
            }
            case 5: {
                return MultiBitECC;
            }
            case 6: {
                return NonVolatileRAM;
            }
            case 7: {
                return CRC;
            }
        }
        return null;
    }
}

