/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMTP;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SMTP.SMTPCommand;
import Gbt.utility.SMTP.SMTPEmailJSONData;
import Gbt.utility.SMTP.SMTPJSONData;
import java.math.BigInteger;

public enum SMTPIPMIOptions implements GbtIPMIOptions<SMTPCommand.Builder>
{
    SetSenderInfo(0, "Set SMTP sender info", 80),
    SetEmail(1, "Set SMTP email", 80),
    SetServerAddr(2, "Set SMTP server address", 80),
    SetAuthority(3, "Set SMTP server authority", 80),
    GetSenderInfo(4, "Get SMTP sender info", 81),
    GetEmail(5, "Get SMTP email", 81),
    GetServerAddr(6, "Get SMTP server address", 81),
    GetAuthority(7, "Get SMTP server authority", 81),
    FullGetSMTP(8, "Full get SMTP configurations.", 81);

    private static final int SetSenderInfoCode = 0;
    private static final int SetEmailCode = 1;
    private static final int SetServerAddrCode = 2;
    private static final int SetAuthorityCode = 3;
    private static final int GetSenderInfoCode = 4;
    private static final int GetEmailCode = 5;
    private static final int GetServerAddrCode = 6;
    private static final int GetAuthorityCode = 7;
    private static final int FullGetConfigCode = 8;
    private static final String SetSenderInfoItem = "Set SMTP sender info";
    private static final String SetEmailItem = "Set SMTP email";
    private static final String SetServerAddrItem = "Set SMTP server address";
    private static final String SetAuthorityItem = "Set SMTP server authority";
    private static final String GetSenderInfoItem = "Get SMTP sender info";
    private static final String GetEmailItem = "Get SMTP email";
    private static final String GetServerAddrItem = "Get SMTP server address";
    private static final String GetAuthorityItem = "Get SMTP server authority";
    private static final String FullGetConfigItem = "Full get SMTP configurations.";
    private final int code;
    private final String item;
    private static final byte NET_FN = 46;
    private final byte cmd;

    private SMTPIPMIOptions(int code, String item, byte cmd) {
        this.code = code;
        this.item = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.code;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 46;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(SMTPCommand.Builder commandArgs) {
        byte[] requestData = null;
        byte[] oemTemp = null;
        switch (this) {
            case SetSenderInfo: {
                oemTemp = new byte[]{10, 60, 0, 6};
                requestData = new byte[oemTemp.length + commandArgs.senderInfo.length];
                for (int i = 0; i < requestData.length; ++i) {
                    requestData[i] = i < oemTemp.length ? oemTemp[i] : commandArgs.senderInfo[i - oemTemp.length];
                }
                return requestData;
            }
            case SetEmail: {
                oemTemp = new byte[]{10, 60, 0, commandArgs.emailID, commandArgs.enable};
                requestData = new byte[oemTemp.length + commandArgs.emailDescription.length + commandArgs.emailAddr.length];
                for (int i = 0; i < requestData.length; ++i) {
                    requestData[i] = i < oemTemp.length ? oemTemp[i] : (i < oemTemp.length + commandArgs.emailDescription.length ? commandArgs.emailDescription[i - oemTemp.length] : commandArgs.emailAddr[i - (oemTemp.length + commandArgs.emailDescription.length)]);
                }
                return requestData;
            }
            case SetServerAddr: {
                oemTemp = new byte[]{10, 60, 0, 11};
                requestData = new byte[oemTemp.length + commandArgs.portBytes.length + commandArgs.serverAddr.length];
                for (int i = 0; i < requestData.length; ++i) {
                    requestData[i] = i < oemTemp.length ? oemTemp[i] : (i < oemTemp.length + commandArgs.portBytes.length ? commandArgs.portBytes[i - oemTemp.length] : commandArgs.serverAddr[i - (oemTemp.length + commandArgs.portBytes.length)]);
                }
                return requestData;
            }
            case SetAuthority: {
                oemTemp = new byte[]{10, 60, 0, 12, commandArgs.enable};
                requestData = new byte[oemTemp.length + commandArgs.usernameBytes.length + commandArgs.passwordBytes.length + 2];
                for (int i = 0; i < requestData.length; ++i) {
                    requestData[i] = i < oemTemp.length ? oemTemp[i] : (i < oemTemp.length + commandArgs.usernameBytes.length ? commandArgs.usernameBytes[i - oemTemp.length] : (i < requestData.length - 2 ? commandArgs.passwordBytes[i - (oemTemp.length + commandArgs.usernameBytes.length)] : (i < requestData.length - 1 ? commandArgs.TLSMode : commandArgs.SASLMode)));
                }
                return requestData;
            }
            case GetSenderInfo: {
                requestData = new byte[]{10, 60, 0, 6};
                return requestData;
            }
            case GetEmail: {
                requestData = new byte[]{10, 60, 0, commandArgs.emailID};
                return requestData;
            }
            case GetServerAddr: {
                requestData = new byte[]{10, 60, 0, 11};
                return requestData;
            }
            case GetAuthority: {
                requestData = new byte[]{10, 60, 0, 12};
                return requestData;
            }
        }
        return requestData;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        switch (this.code) {
            case 0: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " command complete.");
            }
            case 1: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " command complete.");
            }
            case 2: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " command complete.");
            }
            case 3: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " command complete.");
            }
            case 4: {
                SMTPJSONData senderInfo = new SMTPJSONData();
                byte[] temp = new byte[128];
                System.arraycopy(gbtResponseData.getAllResponseData(), 3, temp, 0, temp.length);
                senderInfo.setSenderInfo(GbtCommonConverters.asciiBytesToString(temp));
                return senderInfo;
            }
            case 5: {
                SMTPEmailJSONData emailData = new SMTPEmailJSONData();
                byte enableAddr = gbtResponseData.getAllResponseData()[3];
                switch (enableAddr) {
                    case 1: {
                        emailData.setEnable(Boolean.TRUE);
                        break;
                    }
                    case 2: {
                        emailData.setEnable(Boolean.TRUE);
                        break;
                    }
                    default: {
                        emailData.setEnable(Boolean.FALSE);
                    }
                }
                byte[] emailAddr = new byte[gbtResponseData.getAllResponseData().length - 68];
                System.arraycopy(gbtResponseData.getAllResponseData(), 68, emailAddr, 0, emailAddr.length);
                emailData.setEmail(new String(emailAddr).replaceAll("\u0000+$", ""));
                byte[] description = new byte[64];
                System.arraycopy(gbtResponseData.getAllResponseData(), 4, description, 0, 64);
                emailData.setDescription(GbtCommonConverters.asciiBytesToString(description));
                return emailData;
            }
            case 6: {
                SMTPJSONData serverAddr = new SMTPJSONData();
                byte[] port = new byte[2];
                System.arraycopy(gbtResponseData.getAllResponseData(), 3, port, 0, port.length);
                int serverPort = ((port[1] & 0xFF) << 8) + (port[0] & 0xFF);
                serverAddr.setServerPort(new BigInteger(String.valueOf(serverPort)));
                byte[] serverIP = new byte[gbtResponseData.getAllResponseData().length - 5];
                System.arraycopy(gbtResponseData.getAllResponseData(), 5, serverIP, 0, serverIP.length);
                if (this.isIPv4Data(serverIP)) {
                    byte[] IPv4Temp = new byte[4];
                    System.arraycopy(gbtResponseData.getAllResponseData(), 5, IPv4Temp, 0, IPv4Temp.length);
                    serverAddr.setServerIP(GbtCommonConverters.bytesToIPv4Address(IPv4Temp));
                } else {
                    serverAddr.setServerIP(GbtCommonConverters.bytesToIPv6Address(serverIP));
                }
                return serverAddr;
            }
            case 7: {
                SMTPJSONData serverAuth = new SMTPJSONData();
                byte enable = gbtResponseData.getAllResponseData()[3];
                byte[] usernameBytes = new byte[64];
                System.arraycopy(gbtResponseData.getAllResponseData(), 4, usernameBytes, 0, 64);
                byte[] passwordBytes = new byte[64];
                System.arraycopy(gbtResponseData.getAllResponseData(), 68, passwordBytes, 0, 64);
                byte TLSMode = gbtResponseData.getAllResponseData()[gbtResponseData.getAllResponseData().length - 2];
                byte SASLMode = gbtResponseData.getAllResponseData()[gbtResponseData.getAllResponseData().length - 1];
                if (enable == 0) {
                    serverAuth.setServerEnable(Boolean.FALSE);
                } else {
                    serverAuth.setServerEnable(Boolean.TRUE);
                }
                serverAuth.setServerUsername(GbtCommonConverters.asciiBytesToString(usernameBytes));
                serverAuth.setServerPassword(GbtCommonConverters.asciiBytesToString(passwordBytes));
                switch (TLSMode) {
                    case 0: {
                        serverAuth.setTLSMode("OFF");
                        break;
                    }
                    case 1: {
                        serverAuth.setTLSMode("Auto");
                        break;
                    }
                    case 2: {
                        serverAuth.setTLSMode("ON");
                        break;
                    }
                }
                switch (SASLMode) {
                    case 0: {
                        serverAuth.setSASLMode("Auto");
                        break;
                    }
                    case 1: {
                        serverAuth.setSASLMode("Plain");
                        break;
                    }
                    case 2: {
                        serverAuth.setSASLMode("Login");
                        break;
                    }
                    case 3: {
                        serverAuth.setSASLMode("NTLM");
                        break;
                    }
                    case 4: {
                        serverAuth.setSASLMode("MD5");
                        break;
                    }
                }
                return serverAuth;
            }
        }
        return new NullJSONData().setError(true).setMessages("Unknown SMTP option.");
    }

    private boolean isIPv4Data(byte[] IPBytes) {
        if (IPBytes.length == 4) {
            return true;
        }
        int count = 1;
        for (int i = 4; i < IPBytes.length; ++i) {
            if (IPBytes[i] != 0) continue;
            ++count;
        }
        return count != IPBytes.length - 4;
    }
}

