/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmcinfo;

import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BMCVendor {
    UNKNOWN(0, "unknown"),
    VERTIV(0, "vertiv"),
    AMI(1, "ami"),
    OPENBMC(5, "openbmc");

    private static final byte VERTIV_CODE = 0;
    private static final byte AMI_CODE = 1;
    private static final byte OPEN_BMC_CODE = 5;
    private static final String UNKNOWN_ITEM = "unknown";
    private static final String VERTIV_ITEM = "vertiv";
    private static final String AMI_ITEM = "ami";
    private static final String OPEN_BMC_ITEM = "openbmc";
    private final byte code;
    private final String item;

    private BMCVendor(byte code, String item) {
        this.code = code;
        this.item = item;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public byte getTypeCode() {
        return this.code;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isAMI() {
        return this == AMI;
    }

    public boolean isVertiv() {
        return this == VERTIV;
    }

    public boolean isOpenBMC() {
        return this == OPENBMC;
    }

    public static final BMCVendor parse(String verdorName) {
        if (verdorName == null) {
            return UNKNOWN;
        }
        switch (verdorName.toUpperCase()) {
            case "vertiv": {
                return VERTIV;
            }
            case "ami": {
                return AMI;
            }
            case "openbmc": {
                return OPENBMC;
            }
        }
        return UNKNOWN;
    }

    public static final BMCVendor parse(byte vendorCode) {
        switch (vendorCode) {
            case 0: {
                return VERTIV;
            }
            case 1: {
                return AMI;
            }
            case 5: {
                return OPENBMC;
            }
        }
        return UNKNOWN;
    }

    public static final BMCVendor parse(GbtIpmiCommandResponseData ipmiResponse) {
        if (ipmiResponse == null) {
            return UNKNOWN;
        }
        if (!ipmiResponse.isHasResponseData()) {
            return VERTIV;
        }
        switch (ipmiResponse.getResponseData(ipmiResponse.getAllResponseData().length - 1)) {
            case 0: {
                return VERTIV;
            }
            case 1: {
                return AMI;
            }
            case 5: {
                return OPENBMC;
            }
        }
        return UNKNOWN;
    }
}

