/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.firmwareBackup;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.Update.MainUpdateCommand;
import Gbt.utility.firmwareBackup.CommandSupportStatus;

public enum FirmwareBackupOperateIpmiOptions implements GbtIPMIOptions<MainUpdateCommand.Builder>
{
    BIOS0_BIOS1(0, "BIOS 0 to BIOS 1", 1),
    BIOS1_BIOS0(1, "BIOS 1 to BIOS 0", 2),
    FILE_BIOS0(2, "file to BIOS 0", 3),
    FILE_BIOS1(3, "file to BIOS 1", 4),
    FILE_BIOS01(4, "file to BIOS 0/1", 5),
    BMC0_BMC1(5, "BMC 0 to BMC 1", 17),
    BMC1_BMC0(6, "BMC 1 to BMC 0", 18),
    FILE_BMC0(7, "file to BMC 0", 19),
    FILE_BMC1(8, "file to BMC 1", 20),
    FILE_BMC01(9, "file to BMC 0/1", 21);

    private static final String BIOS0_BIOS1_ITEM = "BIOS 0 to BIOS 1";
    private static final String BIOS1_BIOS0_ITEM = "BIOS 1 to BIOS 0";
    private static final String FILE_BIOS0_ITEM = "file to BIOS 0";
    private static final String FILE_BIOS1_ITEM = "file to BIOS 1";
    private static final String FILE_BIOS01_ITEM = "file to BIOS 0/1";
    private static final String BMC0_BMC1_ITEM = "BMC 0 to BMC 1";
    private static final String BMC1_BMC0_ITEM = "BMC 1 to BMC 0";
    private static final String FILE_BMC0_ITEM = "file to BMC 0";
    private static final String FILE_BMC1_ITEM = "file to BMC 1";
    private static final String FILE_BMC01_ITEM = "file to BMC 0/1";
    private static final byte NetFn = 46;
    private final int optionCode;
    private final String item;
    private static final byte cmd = 32;
    private byte operateByte;

    private FirmwareBackupOperateIpmiOptions(int optionCode, String item, byte operateByte) {
        this.optionCode = optionCode;
        this.item = item;
        this.operateByte = operateByte;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 46;
    }

    @Override
    public byte getCommandCode() {
        return 32;
    }

    @Override
    public byte[] rebuildRequestData(MainUpdateCommand.Builder commandArgs) {
        return new byte[]{10, 60, 0, -124, this.operateByte};
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        return new CommandSupportStatus().setSupport(true).setSuccess(true);
    }
}

