/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.meversion;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.API.GbtUtilityAPI2;
import Gbt.utility.MSR.MsrIpmiOptions;
import Gbt.utility.MSR.NodeManagementData;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.meversion.MeVersionData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.chassis.GetChassisStatusResponseData;

public final class MeVersionCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "meversion";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected MeVersionCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        return this.ipmiReceiver != null;
    }

    @Override
    public boolean execute() {
        NullJSONData temp;
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        CommandTaskRecords report = GbtUtilityAPI2.commonCommand(GbtCommandBuilders.mcinfo(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword));
        AbstractJSONPOJO data = report.getResultData().get(0);
        if (data instanceof NullJSONData) {
            NullJSONData temp2 = data.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp2.getMessages());
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
            return false;
        }
        BMCInfoJSONData bmcInfo = data.castConcreteJSON(BMCInfoJSONData.class);
        if (!bmcInfo.isIntel()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Only support on Intel");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        GetChassisStatusResponseData status = this.ipmiReceiver.getChassisPowerStates(handle, COMMAND_NAME, this.commandID);
        if (!status.isPowerOn()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Node power is off.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Check power status ok.");
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, MsrIpmiOptions.GET_NODE_MANAGEMENT_DATA, null, COMMAND_NAME, this.commandID);
        if (resp instanceof NullJSONData && (temp = resp.castConcreteJSON(NullJSONData.class)).isError()) {
            GbtIPMICommandReceiver.getInstance().closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get node management data success.");
        if (!resp.castConcreteJSON(NodeManagementData.class).getNMSupport().booleanValue()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not supported msr command.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        resp = this.ipmiReceiver.sendIPMIRawCommand(handle, MsrIpmiOptions.GET_ME_VERSION, null, COMMAND_NAME, this.commandID);
        if (resp instanceof NullJSONData && (temp = resp.castConcreteJSON(NullJSONData.class)).isError()) {
            GbtIPMICommandReceiver.getInstance().closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.commandResults.add(resp);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] ME Version : " + resp.castConcreteJSON(MeVersionData.class).getFullVersion());
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private final boolean isIPMISendMessagesFail(AbstractJSONPOJO resp) {
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            if (temp.isError()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.commandResults.add(temp);
                return true;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.commandResults.add(temp);
            return false;
        }
        return false;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                return this.args.length == 0;
            }
            return this.bmcIP != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public MeVersionCommand build() {
            return new MeVersionCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }
    }
}

