/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.networkconfig;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.networkconfig.BMCNetworkConfigIPMIOptions;
import Gbt.utility.networkconfig.BMCNetworkHostnameData;
import com.fasterxml.jackson.annotation.JsonValue;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class BMCNetworkConfigCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "netconfig";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected BMCNetworkConfigCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, this.getCommandName(), this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                break;
            }
            case AMI: 
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Fail to get BMC vendor.");
                return false;
            }
        }
        if (((Builder)this.commandArgs).isSetConfig) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to set BMC network configurations.");
            AbstractJSONPOJO responseData = this.ipmiReceiver.sendIPMIRawCommand(handle, BMCNetworkConfigIPMIOptions.SET_GENERAL, this.commandArgs, COMMAND_NAME, this.commandID);
            if (responseData instanceof NullJSONData) {
                NullJSONData temp = responseData.castConcreteJSON(NullJSONData.class);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            }
        } else {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to get BMC network configurations.");
            AbstractJSONPOJO responseData = this.ipmiReceiver.sendIPMIRawCommand(handle, BMCNetworkConfigIPMIOptions.GET_HOSTNAME, this.commandArgs, COMMAND_NAME, this.commandID);
            if (responseData instanceof BMCNetworkHostnameData) {
                BMCNetworkHostnameData hostname = responseData.castConcreteJSON(BMCNetworkHostnameData.class);
                this.commandResults.add(hostname);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Hostname:" + hostname.getHostname());
            } else if (responseData instanceof NullJSONData) {
                NullJSONData temp = responseData.castConcreteJSON(NullJSONData.class);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    this.commandResults.add(temp);
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.commandResults.add(temp);
            } else {
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Error getting BMC hostname."));
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
        }
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return true;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    public static enum BMCGlobalDynamicDNSStates {
        Disabled(0, "Enabled"),
        Enabled(1, "Disabled"),
        ByInterface(2, "By Interface");

        private static final byte CODE_1 = 0;
        private static final byte CODE_2 = 1;
        private static final byte CODE_3 = 2;
        private static final String ITEM_1 = "Enabled";
        private static final String ITEM_2 = "Disabled";
        private static final String ITEM_3 = "By Interface";
        private final byte code;
        private final String item;

        private BMCGlobalDynamicDNSStates(byte code, String item) {
            this.code = code;
            this.item = item;
        }

        public byte getCode() {
            return this.code;
        }

        @JsonValue
        public String toString() {
            return this.item;
        }

        public static final BMCGlobalDynamicDNSStates parse(String rawString) {
            if (rawString == null) {
                return ByInterface;
            }
            switch (rawString.toLowerCase()) {
                case "off": {
                    return Disabled;
                }
                case "disable": {
                    return Disabled;
                }
                case "on": {
                    return Enabled;
                }
                case "enable": {
                    return Enabled;
                }
                case "auto": {
                    return ByInterface;
                }
            }
            return ByInterface;
        }
    }

    public static enum BMCGlobalDNSStates {
        Disabled(0, "Enabled"),
        Enabled(1, "Disabled");

        private static final byte CODE_1 = 0;
        private static final byte CODE_2 = 1;
        private static final String ITEM_1 = "Enabled";
        private static final String ITEM_2 = "Disabled";
        private final byte code;
        private final String item;

        private BMCGlobalDNSStates(byte code, String item) {
            this.code = code;
            this.item = item;
        }

        public byte getCode() {
            return this.code;
        }

        @JsonValue
        public String toString() {
            return this.item;
        }

        public static final BMCGlobalDNSStates parse(String rawString) {
            if (rawString == null) {
                return Disabled;
            }
            switch (rawString.toLowerCase()) {
                case "off": {
                    return Disabled;
                }
                case "disable": {
                    return Disabled;
                }
                case "on": {
                    return Enabled;
                }
                case "enable": {
                    return Enabled;
                }
            }
            return Disabled;
        }
    }

    public static enum BMCNetworkMode {
        Unknown(0, "Unknown"),
        Dedicated(1, "Dedicated"),
        Shared(2, "Shared"),
        SharedWithFailover(3, "Shared with Failover");

        private static final byte CODE_0 = 0;
        private static final byte CODE_1 = 1;
        private static final byte CODE_2 = 2;
        private static final byte CODE_3 = 3;
        private static final String ITEM_0 = "Unknown";
        private static final String ITEM_1 = "Dedicated";
        private static final String ITEM_2 = "Shared";
        private static final String ITEM_3 = "Shared with Failover";
        private final byte code;
        private final String item;

        private BMCNetworkMode(byte code, String item) {
            this.code = code;
            this.item = item;
        }

        public byte getCode() {
            return this.code;
        }

        @JsonValue
        public String toString() {
            return this.item;
        }

        public static final BMCNetworkMode parse(String rawString) {
            if (rawString == null) {
                return Unknown;
            }
            switch (rawString.toLowerCase()) {
                case "dedicated": {
                    return Dedicated;
                }
                case "shared": {
                    return Shared;
                }
                case "failover": {
                    return SharedWithFailover;
                }
            }
            return Unknown;
        }
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private boolean isSetConfig = false;
        protected String hostName;
        protected String domainName;
        protected BMCNetworkMode networkMode = BMCNetworkMode.Dedicated;
        protected BMCGlobalDNSStates dnsStates = BMCGlobalDNSStates.Enabled;
        protected BMCGlobalDynamicDNSStates dynamicDNSStates = BMCGlobalDynamicDNSStates.ByInterface;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                this.loggerWriter.appendPath(BMCNetworkConfigCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, "0.0.0.0_netconfig", "BMC IP address is null.");
                return false;
            }
            if (this.args != null) {
                if (this.args.length < 1) {
                    this.loggerWriter.appendPath(BMCNetworkConfigCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + BMCNetworkConfigCommand.COMMAND_NAME, "invalid arguments length of set option.");
                    return false;
                }
                switch (this.args[0]) {
                    case "set": {
                        if (this.args.length != 6) {
                            this.loggerWriter.appendPath(BMCNetworkConfigCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + BMCNetworkConfigCommand.COMMAND_NAME, "invalid arguments length of set option.");
                            return false;
                        }
                        this.hostName = this.args[1];
                        this.domainName = this.args[2];
                        this.networkMode = BMCNetworkMode.parse(this.args[3]);
                        this.dnsStates = BMCGlobalDNSStates.parse(this.args[4]);
                        this.dynamicDNSStates = BMCGlobalDynamicDNSStates.parse(this.args[5]);
                        this.isSetConfig = true;
                        break;
                    }
                    case "get": {
                        this.isSetConfig = false;
                        break;
                    }
                    default: {
                        this.loggerWriter.appendPath(BMCNetworkConfigCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + BMCNetworkConfigCommand.COMMAND_NAME, "Unknown option of this command.");
                        return false;
                    }
                }
            }
            if (this.isSetConfig) {
                if (this.hostName.getBytes().length > 64) {
                    this.loggerWriter.appendPath(BMCNetworkConfigCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + BMCNetworkConfigCommand.COMMAND_NAME, "The host name is too long, it must less then 64 bytes.");
                    return false;
                }
                if (this.domainName.getBytes().length > 64) {
                    this.loggerWriter.appendPath(BMCNetworkConfigCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + BMCNetworkConfigCommand.COMMAND_NAME, "The domain name is too long, it must less then 64 bytes.");
                    return false;
                }
                if (this.networkMode == BMCNetworkMode.Unknown) {
                    this.loggerWriter.appendPath(BMCNetworkConfigCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + BMCNetworkConfigCommand.COMMAND_NAME, "Unknown network mode.");
                    return false;
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public BMCNetworkConfigCommand build() {
            return new BMCNetworkConfigCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.isSetConfig = false;
            this.hostName = null;
            this.domainName = null;
            this.networkMode = null;
            this.dnsStates = null;
            this.dynamicDNSStates = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setHostName(String hostName) {
            this.hostName = hostName;
            this.isSetConfig = true;
            return this.getThis();
        }

        public Builder setDomainName(String domainName) {
            this.domainName = domainName;
            this.isSetConfig = true;
            return this.getThis();
        }

        public Builder setNetworkMode(BMCNetworkMode networkMode) {
            this.networkMode = networkMode;
            this.isSetConfig = true;
            return this.getThis();
        }

        public Builder setDnsStates(BMCGlobalDNSStates dnsStates) {
            this.dnsStates = dnsStates;
            this.isSetConfig = true;
            return this.getThis();
        }

        public Builder setAction(boolean isSetConfig) {
            this.isSetConfig = isSetConfig;
            return this.getThis();
        }

        public Builder setDynamicDNSStates(BMCGlobalDynamicDNSStates dynamicDNSStates) {
            this.dynamicDNSStates = dynamicDNSStates;
            this.isSetConfig = true;
            return this.getThis();
        }

        public Builder setPrintConfigMode() {
            this.isSetConfig = false;
            return this.getThis();
        }
    }
}

