/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;

public enum BiosApiOptions implements RedfishApiOptions
{
    UNKNOWN("/redfish/v1/Systems/<id>/Bios"),
    INFO("/redfish/v1/Systems/<id>/Bios"),
    RESET("/redfish/v1/Systems/<id>/Bios/Actions/Bios.ResetBios"),
    PASSWORD("/redfish/v1/Systems/<id>/Bios/Actions/Bios.ChangePassword"),
    SD("/redfish/v1/Systems/<id>/Bios/SD");

    private static final String BIOS_URI = "/redfish/v1/Systems/<id>/Bios";
    private static final String BIOS_RESET_URI = "/redfish/v1/Systems/<id>/Bios/Actions/Bios.ResetBios";
    private static final String BIOS_PASWORD_URI = "/redfish/v1/Systems/<id>/Bios/Actions/Bios.ChangePassword";
    private static final String BIOS_SD = "/redfish/v1/Systems/<id>/Bios/SD";
    private final String mainUri;

    private BiosApiOptions(String mainUri) {
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return super.toString().toLowerCase();
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            default: 
        }
        return "Unsupport option of the Redfish bios API.";
    }

    public String replaceSystemId(String systemID) {
        return this.getMainUri().replace("<id>", systemID);
    }

    public static final BiosApiOptions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        try {
            return BiosApiOptions.valueOf(rawString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }
}

