/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;

public enum SessionServiceApiOptions implements RedfishApiOptions
{
    UNKNOWN("/redfish/v1/SessionService"),
    INFO("/redfish/v1/SessionService"),
    MODIFY("/redfish/v1/SessionService"),
    ADD("/redfish/v1/SessionService/Sessions"),
    GET("/redfish/v1/SessionService/Sessions"),
    DELETE("/redfish/v1/SessionService/Sessions");

    private static final String SESSIONSERVICE_URI = "/redfish/v1/SessionService";
    private static final String SESSIONS_URI = "/redfish/v1/SessionService/Sessions";
    private final String mainUri;

    private SessionServiceApiOptions(String mainUri) {
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return super.toString().toLowerCase();
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            case MODIFY: {
                return "Session service configuration data has not been applied.";
            }
            case ADD: {
                return "Session data has not been applied.";
            }
            case GET: {
                return "Session number has not been applied.";
            }
            case DELETE: {
                return "Session number has not been applied.";
            }
        }
        return "Unsupport option of Redfish session service API.";
    }

    public static final SessionServiceApiOptions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        try {
            return SessionServiceApiOptions.valueOf(rawString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }
}

