/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.RESTClientReceiver;
import Gbt.core.rest.RESTServiceFactory;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.rest.AMIRestServiceFactory;
import Gbt.utility.rest.options.NoServiceOptions;
import Gbt.utility.rest.services.VmediaService;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class RestCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "rest";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private final RESTClientReceiver clientReceiver;

    protected RestCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME + "_" + ((Builder)this.commandArgs).serviceName;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.clientReceiver = RESTClientReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return "rest/" + ((Builder)this.commandArgs).serviceName;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.clientReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] REST client receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).username, ((Builder)this.commandArgs).password, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI's connection fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, this.getCommandName(), this.commandID);
        switch (bmcVendor) {
            case VERTIV: 
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
            case AMI: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                break;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("[" + ((Builder)this.commandArgs).bmcIP + "] Fail to get BMC vendor."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Fail to get BMC vendor.");
                return false;
            }
        }
        ((Builder)this.commandArgs).restServices.setBmcPort(((Builder)this.commandArgs).bmcPort);
        if (!((Builder)this.commandArgs).restServices.openSession(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).username, ((Builder)this.commandArgs).password, ((Builder)this.commandArgs).debugTag)) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Open rest session fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Open rest session fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!((Builder)this.commandArgs).restServices.execute(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).restServicesOptions)) {
            ((Builder)this.commandArgs).restServices.closeSession(((Builder)this.commandArgs).bmcIP);
            this.commandResults.addAll(((Builder)this.commandArgs).restServices.getJsonResults());
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        ((Builder)this.commandArgs).restServices.closeSession(((Builder)this.commandArgs).bmcIP);
        this.commandResults.addAll(((Builder)this.commandArgs).restServices.getJsonResults());
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return true;
    }

    @Override
    public void close() throws Exception {
        if (((Builder)this.commandArgs).restServices == null) {
            ((Builder)this.commandArgs).close();
            return;
        }
        if (!((Builder)this.commandArgs).restServices.getServiceName().equals("vmedia")) {
            ((Builder)this.commandArgs).close();
        }
    }

    @Override
    public void cancelHook(Object obj) {
        if (((Builder)this.commandArgs).restServices == null) {
            return;
        }
        if (((Builder)this.commandArgs).restServices.getServiceName().equals("vmedia")) {
            ((VmediaService)((Builder)this.commandArgs).restServices).unmountIsoImages(((Builder)this.commandArgs).bmcIP);
            try {
                ((Builder)this.commandArgs).close();
            }
            catch (Exception e) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + e.getMessage());
            }
        }
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private int bmcPort = 0;
        private String username = "admin";
        private String password = "password";
        private String serviceName;
        private String serviceOption;
        private RESTServices restServices;
        private RESTServicesOptions restServicesOptions;
        private List<File> jsonPayloads = new ArrayList<File>();
        private List<File> uploadFiles = new ArrayList<File>();
        private boolean debugTag = false;

        public Builder() {
            this.serviceOption = NoServiceOptions.NoOptions.getOptionName();
        }

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            String logId = this.bmcIP + "_" + RestCommand.COMMAND_NAME + "_" + this.serviceName;
            if (this.args != null) {
                switch (this.args.length) {
                    case 0: {
                        this.loggerWriter.appendPath(RestCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, logId, "[" + this.bmcIP + "] rest service name is empty.");
                        return false;
                    }
                    case 1: {
                        this.serviceName = this.args[0];
                        break;
                    }
                    case 2: {
                        this.serviceName = this.args[0];
                        if (this.args[1].equals("debug")) {
                            this.setDebugTag(true);
                            break;
                        }
                        this.serviceOption = this.args[1];
                        break;
                    }
                    default: {
                        this.serviceName = this.args[0];
                        this.serviceOption = this.args[1];
                        if (!this.jsonPayloads.isEmpty() || !this.uploadFiles.isEmpty()) break;
                        for (int i = 2; i < this.args.length; ++i) {
                            if (this.args[i].endsWith(".json")) {
                                this.setJsonPayloads(GbtCommonConverters.stringToJavaIoFile(this.args[i]));
                                continue;
                            }
                            if (this.args[i].equals("debug")) {
                                this.setDebugTag(true);
                                continue;
                            }
                            this.setUploadFiles(GbtCommonConverters.stringToJavaIoFile(this.args[i]));
                        }
                    }
                }
            }
            if (this.serviceName == null) {
                this.loggerWriter.appendPath(RestCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, logId, "[" + this.bmcIP + "] REST service name is empty.");
                return false;
            }
            AMIRestServiceFactory serviceFactory = AMIRestServiceFactory.getFactory();
            this.restServices = ((RESTServiceFactory)serviceFactory).createService(this.serviceName, this.loggerWriter);
            if (this.restServices == null) {
                this.loggerWriter.appendPath(RestCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, logId, "[" + this.bmcIP + "] Unknown REST service name \"" + this.serviceName + "\".");
                return false;
            }
            this.restServicesOptions = ((RESTServiceFactory)serviceFactory).getServiceOptions(this.restServices, this.serviceOption);
            if (NoServiceOptions.isNullOption(this.restServicesOptions)) {
                this.loggerWriter.appendPath(RestCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, logId, "[" + this.bmcIP + "] No such rest service option.");
                return false;
            }
            if (!this.restServices.readJsonFiles(this.jsonPayloads, this.restServicesOptions)) {
                this.loggerWriter.appendPath(RestCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, logId, "[" + this.bmcIP + "] Cannot read the json request payload file.");
                return false;
            }
            if (!this.restServices.uploadFiles(this.uploadFiles, this.restServicesOptions)) {
                this.loggerWriter.appendPath(RestCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, logId, "[" + this.bmcIP + "] Cannot read the upload file.");
                return false;
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public RestCommand build() {
            if (this.args != null) {
                if (this.args.length > 0) {
                    this.serviceName = this.args[0];
                }
                if (this.args.length > 1) {
                    this.serviceOption = this.args[1];
                }
            }
            return new RestCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            if (bmcIP.contains(":")) {
                this.bmcIP = bmcIP.split(":")[0];
                this.setBmcPort(Integer.parseInt(bmcIP.split(":")[1], 10));
            } else {
                this.bmcIP = bmcIP;
            }
            return this.getThis();
        }

        public Builder setBmcPort(int bmcPort) {
            this.bmcPort = bmcPort;
            return this.getThis();
        }

        public Builder setBMCUsername(String userName) {
            this.username = userName;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.password = password;
            return this.getThis();
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this.getThis();
        }

        public Builder setServiceOption(String serviceOption) {
            this.serviceOption = serviceOption;
            return this.getThis();
        }

        public Builder setJsonPayloads(File jsonPayloads) {
            this.jsonPayloads.add(jsonPayloads);
            return this.getThis();
        }

        public Builder setUploadFiles(File uploadFiles) {
            this.uploadFiles.add(uploadFiles);
            return this.getThis();
        }

        public Builder setDebugTag(boolean debugTag) {
            this.debugTag = debugTag;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.username = null;
            this.password = null;
            this.serviceOption = null;
            this.jsonPayloads.clear();
            this.jsonPayloads = null;
            this.uploadFiles.clear();
            this.uploadFiles = null;
            this.debugTag = false;
            this.loggerWriter.close();
        }
    }
}

